/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.modelingunit;

import org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.ModelingUnitSerializer;

public final class ModelingUnitFormatter {
    private ModelingUnitFormatter() {
    }

    public static String format(String modelingUnitToFormat) {
        String formattedString = modelingUnitToFormat.toString();
        formattedString = formattedString.replaceAll(";[\t ]*\n[\t ]*", ";\n");
        formattedString = formattedString.replaceAll("@M\\s*", "");
        formattedString = formattedString.replace("M@\n", "");
        return formattedString;
    }

    public static String indentAccordingToBrackets(ModelingUnitSerializer serializer, String modelingUnitToFormat) {
        return ModelingUnitFormatter.indentAccordingToBrackets(serializer, modelingUnitToFormat, 0, 0);
    }

    public static String indentAccordingToBrackets(ModelingUnitSerializer serializer, String modelingUnitToFormat, int initialIndentLevel, int initialOffset) {
        StringBuilder indented = new StringBuilder();
        String[] lines = modelingUnitToFormat.split("\n");
        int currentOffset = 0;
        int nbTabulate = initialIndentLevel;
        int i = 0;
        while (i < lines.length) {
            boolean isClosing;
            boolean bl = isClosing = lines[i].contains("}") && !lines[i].contains("{") && !lines[i].substring(lines[i].indexOf("}")).contains("\"");
            if (isClosing || lines[i].contains("M@")) {
                --nbTabulate;
            }
            int j = 0;
            while (j < nbTabulate) {
                lines[i] = "\t" + lines[i];
                ++j;
            }
            if (nbTabulate > 0) {
                serializer.addTabulations(currentOffset + initialOffset, nbTabulate);
            }
            if (lines[i].contains("{") || lines[i].contains("@M")) {
                ++nbTabulate;
            }
            indented.append(String.valueOf(lines[i]) + "\n");
            if (lines[i].contains("}") && lines[i].contains("{")) {
                --nbTabulate;
            }
            currentOffset = indented.length();
            ++i;
        }
        return indented.toString();
    }
}

