/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.repository;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexerFactory;
import org.eclipse.mylyn.docs.intent.parser.IntentParser;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;

public final class IntentRepositoryInitializer {
    private IntentRepositoryInitializer() {
    }

    public static void initializeContent(String repositoryIdentifier, String initialContent) {
        try {
            Repository repository = IntentRepositoryManager.INSTANCE.getRepository(repositoryIdentifier);
            repository.getOrCreateSession();
            IntentRepositoryInitializer.initializeWithSampleContent(repository, initialContent);
        }
        catch (CoreException e) {
            IntentLogger.getInstance().logError(e);
        }
        catch (RepositoryConnectionException e) {
            IntentLogger.getInstance().logError(e);
        }
    }

    private static void initializeWithSampleContent(Repository repositoryToInitialize, final String initialContent) throws RepositoryConnectionException {
        final RepositoryAdapter repositoryAdapter = repositoryToInitialize.createRepositoryAdapter();
        repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                try {
                    repositoryAdapter.openSaveContext();
                    IntentRepositoryInitializer.initializeInRepository(initialContent, repositoryAdapter);
                }
                catch (ReadOnlyException e) {
                    IntentLogger.getInstance().logError(e);
                }
                catch (ParseException e) {
                    IntentLogger.getInstance().logError(e);
                }
                catch (SaveException e) {
                    IntentLogger.getInstance().logError(e);
                }
                repositoryAdapter.closeContext();
            }
        });
    }

    private static void initializeInRepository(String initialContent, RepositoryAdapter repositoryAdapter) throws ReadOnlyException, SaveException, ParseException {
        Resource wpResourceIndex = repositoryAdapter.getOrCreateResource("/IntentIndex");
        wpResourceIndex.getContents().add((Object)IntentIndexerFactory.eINSTANCE.createIntentIndex());
        Resource wpCompilStatusIndex = repositoryAdapter.getOrCreateResource("/COMPILATION/STATUS/StatusIndex");
        wpCompilStatusIndex.getContents().add((Object)CompilerFactory.eINSTANCE.createCompilationStatusManager());
        Resource wpTracabilityIndexResource = repositoryAdapter.getOrCreateResource("/COMPILATION/TRACES/TraceabilityIndex");
        wpTracabilityIndexResource.getContents().add((Object)CompilerFactory.eINSTANCE.createTraceabilityIndex());
        Resource repositoryIntentResource = repositoryAdapter.getOrCreateResource("/INTENT/IntentDocument");
        if (repositoryIntentResource.getContents().size() == 0) {
            repositoryIntentResource.getContents().clear();
            ArrayList<EObject> elementsToUpload = new ArrayList<EObject>();
            EObject parsedObject = new IntentParser().parse(initialContent);
            elementsToUpload.add(parsedObject);
            for (EObject objectToCopy : elementsToUpload) {
                repositoryIntentResource.getContents().add((Object)EcoreUtil.copy((EObject)objectToCopy));
            }
            repositoryAdapter.save();
        } else {
            repositoryAdapter.undo();
        }
    }
}

