/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.cdo.adapters;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotificationFactoryHolder;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOTypeListener
implements IListener {
    private final Notificator listeningTypeNotificator;
    private final Set<EStructuralFeature> listennedTypes;

    public CDOTypeListener(Notificator typeNotificator, Set<EStructuralFeature> types) {
        this.listeningTypeNotificator = typeNotificator;
        this.listennedTypes = new LinkedHashSet<EStructuralFeature>();
        this.listennedTypes.addAll(types);
    }

    public void notifyEvent(IEvent event) {
        if (event instanceof CDOSessionInvalidationEvent) {
            RepositoryChangeNotification newNotification;
            CDOSessionInvalidationEvent invalidationEvent = (CDOSessionInvalidationEvent)event;
            boolean changesDetected = false;
            block0: for (CDORevisionKey key : invalidationEvent.getChangedObjects()) {
                if (changesDetected) break;
                CDORevisionDelta revisionDelta = (CDORevisionDelta)key;
                for (CDOFeatureDelta delta : revisionDelta.getFeatureDeltas()) {
                    if (!this.isListenedTypeModification(delta.getFeature())) continue;
                    changesDetected = true;
                    continue block0;
                }
            }
            if (changesDetected && (newNotification = RepositoryChangeNotificationFactoryHolder.getChangeNotificationFactory().createRepositoryChangeNotification((Object)invalidationEvent)) != null) {
                this.listeningTypeNotificator.notifyHandlers(newNotification);
            }
        }
    }

    private boolean isListenedTypeModification(EStructuralFeature feature) {
        boolean isListennedType = false;
        Iterator<EStructuralFeature> iterator = this.listennedTypes.iterator();
        while (iterator.hasNext() && !isListennedType) {
            ENamedElement listennedtype = (ENamedElement)iterator.next();
            if (listennedtype instanceof EStructuralFeature) {
                isListennedType = listennedtype.equals(feature);
            }
            if (!(listennedtype instanceof EClass)) continue;
            isListennedType = ((EClass)listennedtype).getEAllStructuralFeatures().contains((Object)feature);
        }
        return isListennedType;
    }
}

