/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentPairMatcher;
import org.eclipse.swt.widgets.Display;

public final class IntentReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private final Map<Annotation, Position> addedAnnotations = new HashMap<Annotation, Position>();
    private final Map<Annotation, Position> currentAnnotations = new HashMap<Annotation, Position>();
    private final List<Annotation> deletedAnnotations = new ArrayList<Annotation>();
    private final IntentEditor editor;
    private final Map<Annotation, Position> modifiedAnnotations = new HashMap<Annotation, Position>();
    private IDocument document;
    private int offset;
    private IntentPairMatcher pairMatcher = new IntentPairMatcher();

    public IntentReconcilingStrategy(IntentEditor editor) {
        this.editor = editor;
    }

    public void initialReconcile() {
        this.offset = 0;
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion partition) {
        this.offset = partition.getOffset();
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void computePositions() {
        this.deletedAnnotations.clear();
        this.modifiedAnnotations.clear();
        this.addedAnnotations.clear();
        this.deletedAnnotations.addAll(this.currentAnnotations.keySet());
        for (Map.Entry<Annotation, Position> entry : this.currentAnnotations.entrySet()) {
            Position position = entry.getValue();
            if (position.getOffset() + position.getLength() >= this.offset) continue;
            this.deletedAnnotations.remove(entry.getKey());
        }
        try {
            boolean eof = this.seekBlockStart();
            int startOffset = this.offset;
            while (!eof) {
                String documentZone;
                int endOffset;
                ++this.offset;
                if (this.document.getLineOfOffset(startOffset) > 0 && this.document.getContentType(startOffset).equals("__Intent__structuralcontent")) {
                    IRegion match = this.pairMatcher.match(this.document, this.offset);
                    if (match != null && this.document.getNumberOfLines(startOffset, (endOffset = match.getOffset() + match.getLength() + 1) - startOffset) > 2) {
                        this.createOrUpdateAnnotation(startOffset, endOffset - startOffset, false);
                    }
                } else if (this.document.getLineOfOffset(startOffset) > 0 && this.document.getContentType(startOffset).equals("__Intent__modelingunit") && (endOffset = (documentZone = this.document.get().substring(startOffset)).indexOf("M@") + 2) > -1) {
                    this.createOrUpdateAnnotation(startOffset - 1, endOffset, this.shouldCollapseModelingUnitByDefault());
                }
                eof = this.seekBlockStart();
                startOffset = this.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
        for (Annotation deleted : this.deletedAnnotations) {
            this.currentAnnotations.remove(deleted);
        }
    }

    private boolean seekBlockStart() throws BadLocationException {
        char next = this.document.getChar(this.offset);
        int previous = 32;
        boolean eof = this.offset + 1 >= this.document.getLength();
        boolean foundModelingUnit = false;
        while (!eof && next != '{' && !foundModelingUnit) {
            ++this.offset;
            previous = next;
            next = this.document.getChar(this.offset);
            eof = this.offset + 1 == this.document.getLength();
            boolean bl = foundModelingUnit = next == 'M' && previous == 64;
        }
        return eof;
    }

    private void createOrUpdateAnnotation(int newOffset, int newLength, boolean initiallyCollapsed) throws BadLocationException {
        boolean createAnnotation = true;
        HashMap<Annotation, Position> copy = new HashMap<Annotation, Position>(this.currentAnnotations);
        String text = this.document.get(newOffset, newLength);
        for (Map.Entry entry : copy.entrySet()) {
            if (!((Annotation)entry.getKey()).getText().equals(text) || ((Position)entry.getValue()).getOffset() != newOffset) continue;
            createAnnotation = false;
            Position oldPosition = (Position)entry.getValue();
            if (oldPosition.getOffset() != newOffset || oldPosition.getLength() != newLength) {
                Position newPosition = new Position(newOffset, newLength);
                this.modifiedAnnotations.put((Annotation)entry.getKey(), newPosition);
                this.currentAnnotations.put((Annotation)entry.getKey(), newPosition);
            }
            this.deletedAnnotations.remove(entry.getKey());
            break;
        }
        if (createAnnotation) {
            ProjectionAnnotation annotation = null;
            annotation = new ProjectionAnnotation(initiallyCollapsed);
            annotation.setText(text);
            Position position = new Position(newOffset, newLength);
            this.currentAnnotations.put((Annotation)annotation, position);
            this.addedAnnotations.put((Annotation)annotation, position);
        }
    }

    private void updateFoldingStructure() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IntentReconcilingStrategy.this.editor.updateFoldingStructure(IntentReconcilingStrategy.this.addedAnnotations, IntentReconcilingStrategy.this.deletedAnnotations, IntentReconcilingStrategy.this.modifiedAnnotations);
            }
        });
    }

    private boolean shouldCollapseModelingUnitByDefault() {
        return IntentEditorActivator.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.collapse_mu") && !this.editor.isInitialFoldingStructureComplete();
    }
}

