/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.basicchunk;

import com.ibm.jbatch.tck.artifacts.basicchunk.BasicItem;
import com.ibm.jbatch.tck.artifacts.basicchunk.BasicWriterException;
import java.io.Serializable;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="basicWriter")
public class BasicWriter
extends AbstractItemWriter {
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="throw.writer.exception.for.these.items")
    String injectedThrowWriterExceptionForTheseItems;
    private int[] throwWriterExceptionForTheseItems = new int[0];
    private BasicItem currentItem = null;

    public void open(Serializable cpd) throws Exception {
        if (this.injectedThrowWriterExceptionForTheseItems != null) {
            String[] exceptionsStringArray = this.injectedThrowWriterExceptionForTheseItems.split(",");
            this.throwWriterExceptionForTheseItems = new int[exceptionsStringArray.length];
            for (int i = 0; i < exceptionsStringArray.length; ++i) {
                this.throwWriterExceptionForTheseItems[i] = Integer.parseInt(exceptionsStringArray[i]);
            }
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            this.currentItem = (BasicItem)item;
            if (this.writerExceptionShouldBeThrownForCurrentItem()) {
                this.jobCtx.setExitStatus("BasicWriterException:Item#" + this.currentItem.getId());
                throw new BasicWriterException("BasicWriterException thrown for item " + this.currentItem.getId());
            }
            this.currentItem.setWritten(true);
        }
    }

    private boolean writerExceptionShouldBeThrownForCurrentItem() {
        for (int i : this.throwWriterExceptionForTheseItems) {
            if (this.currentItem.getId() != i) continue;
            return true;
        }
        return false;
    }
}

