/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.ConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.InventoryCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.InventoryRecord;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.batch.api.chunk.AbstractItemReader;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="inventoryInitReader")
public class InventoryInitReader
extends AbstractItemReader {
    protected DataSource dataSource = null;
    private int count = 0;

    public void open(Serializable cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
    }

    public InventoryRecord readItem() throws SQLException {
        InventoryRecord inventoryRecord;
        if (this.count > 0) {
            return null;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select itemID, quantity from app.inventory where itemID = ?");
            statement.setInt(1, 1);
            rs = statement.executeQuery();
            int quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
                ++this.count;
            }
            inventoryRecord = new InventoryRecord(1, quantity);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, rs, statement);
        return inventoryRecord;
    }

    public Serializable checkpointInfo() throws Exception {
        InventoryCheckpointData chkpData = new InventoryCheckpointData();
        chkpData.setInventoryCount(this.count);
        return chkpData;
    }
}

