/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.listener.AbstractItemProcessListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="myItemProcessListenerImpl")
public class MyItemProcessListenerImpl
extends AbstractItemProcessListener {
    private static final String sourceClass = MyItemProcessListenerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    int beforecounter = 1;
    int aftercounter = 1;
    public static final String GOOD_EXIT_STATUS = "MyItemProcessListenerImpl: GOOD STATUS";
    public static final String BAD_EXIT_STATUS = "MyItemProcessListenerImpl: BAD STATUS";
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="app.listenertest")
    String applistenerTest;

    public void beforeProcess(Object item) {
        if (item != null && "PROCESS".equals(this.applistenerTest)) {
            logger.finer("In afterRead(), item = " + ((ReadRecord)item).getCount());
            ++this.beforecounter;
        }
    }

    public void afterProcess(Object input, Object result) throws Exception {
        if (input != null && "PROCESS".equals(this.applistenerTest)) {
            logger.finer("In afterProcess(), input = " + ((ReadRecord)input).getCount() + ", output = " + ((ReadRecord)result).getCount());
            ++this.aftercounter;
            if (this.beforecounter == this.aftercounter) {
                this.jobCtx.setExitStatus(GOOD_EXIT_STATUS);
            } else {
                this.jobCtx.setExitStatus(BAD_EXIT_STATUS);
            }
        }
    }

    public void onProcessError(Object input, Exception e) throws Exception {
        logger.finer("In onProcessError(), input = " + e);
        this.jobCtx.setExitStatus("MyItemProcessListenerImpl.onProcessError");
    }
}

