/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.reusable.StopOnBulletinBoardTestData;
import java.io.Serializable;
import java.util.Random;
import java.util.logging.Logger;
import javax.batch.api.AbstractBatchlet;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="myLongRunningBatchlet")
public class MyLongRunningBatchletImpl
extends AbstractBatchlet {
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="run.indefinitely")
    private String runIndefinitelyString = null;
    private boolean runIndefinitely = false;
    @Inject
    @BatchProperty(name="throw.exc.on.number.3")
    private String throwExcOnThreeString = null;
    private boolean throwExcOnThree = false;
    @Inject
    private StepContext stepCtx = null;
    private static final String sourceClass = MyLongRunningBatchletImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private volatile boolean stopped = false;

    private void begin() throws Exception {
        logger.fine("MyLongRunningBatchletImpl.begin()");
        StopOnBulletinBoardTestData testData = (StopOnBulletinBoardTestData)this.stepCtx.getPersistentUserData();
        if (testData == null) {
            testData = new StopOnBulletinBoardTestData();
            this.stepCtx.setPersistentUserData((Serializable)testData);
        }
        long currentThreadId = Thread.currentThread().getId();
        testData.addThreadIdToList(currentThreadId);
        logger.fine("Running on thread: " + currentThreadId);
        logger.finer("Complete list of threads for this partition:");
        for (long l : testData.getThreadIdArrayList()) {
            logger.finer("Next thread = " + l);
        }
        if ("true".equalsIgnoreCase(this.runIndefinitelyString)) {
            this.runIndefinitely = true;
        }
        if ("true".equalsIgnoreCase(this.throwExcOnThreeString)) {
            this.throwExcOnThree = true;
        }
    }

    public String process() throws Exception {
        logger.fine("MyLongRunningBatchLetImpl.process(); current ExitStatus = " + this.jobCtx.getExitStatus());
        this.begin();
        int i = 0;
        int numTimesToRun = 500;
        boolean maxTimesReached = false;
        while (!this.stopped) {
            if (i % 100000 == 0) {
                logger.fine("i=" + i++);
            } else {
                logger.finest("i=" + i++);
            }
            if (i == 3 && this.throwExcOnThree) {
                logger.fine("Throwing exception to confirm fail+restart handling on unchecked exceptions.");
                throw new RuntimeException("Throwing exception to confirm fail+restart handling on unchecked exceptions.");
            }
            for (int k = 0; k < 100; ++k) {
                Random r = new Random(k);
                r.nextInt();
            }
            if (this.runIndefinitely || i < numTimesToRun) continue;
            maxTimesReached = true;
            break;
        }
        if (maxTimesReached) {
            String currentExitStatus = this.jobCtx.getExitStatus();
            if (currentExitStatus != null) {
                this.jobCtx.setExitStatus("GOOD.STEP." + currentExitStatus);
            } else {
                this.jobCtx.setExitStatus("NOT.FINAL.ONE.SHOULD.HAVE.NO.EFFECT");
                this.jobCtx.setExitStatus("GOOD.STEP");
            }
            return "BATCHLET RAN TO COMPLETION";
        }
        this.jobCtx.setExitStatus("BATCHLET CANCELED BEFORE COMPLETION");
        return "BATCHLET CANCELED BEFORE COMPLETION";
    }

    public void stop() throws Exception {
        logger.fine("MyLongRunningBatchLetImpl.cancel()");
        this.stopped = true;
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

