/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.ann.SpecRef;
import com.ibm.jbatch.tck.ann.TCKTest;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import org.junit.Before;
import org.testng.Reporter;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class PartitionRerunTests {
    static JobOperatorBridge jobOp = null;

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    public void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            PartitionRerunTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
        jobOp = null;
    }

    @BeforeTest
    @Before
    public void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterTest
    public void afterTest() {
        jobOp = null;
    }

    @TCKTest(versions={"1.1.WORKING"}, assertions={"Upon job restart, only FAILED partitions of a FAILED partitioned step are re-executed (COMPLETED partitions are not re-executed).", "Upon job restart, all partitions of a COMPLETED partitioned step with allow-start-if-complete=true are re-executed."}, specRefs={@SpecRef(version="1.0", section="8.2", citations={"allow-start-if-complete: Specifies whether this step is allowed to start during job restart, even if the step completed in a previous execution."}), @SpecRef(version="1.0", section="10.8.4", citations={"if the step is a partitioned step, only the partitions that did not complete previously are restarted."}, notes={"See 3.c."})}, issueRefs={"https://java.net/bugzilla/show_bug.cgi?id=6494"}, strategy="In the first job execution, the test fails in one partition and passes in the other two while running through step1. In the second execution, check that only the failed partition in step1 is re-executed; complete step1 and then fail in step2. In the third execution, since step1 has previously completed and allow-start-if-complete=true, we verify that all three partitions in step1 are re-executed.", notes={"The spec doesn't explicitly describe this combination of partitions plus allow-start-if-complete=\"true\", but it seems the only valid interpretation."})
    @Test
    @org.junit.Test
    public void testRerunPartitionAndBatchlet() throws Exception {
        Properties origParams = new Properties();
        origParams.setProperty("force.failure", "true");
        origParams.setProperty("force.failure2", "false");
        TCKJobExecutionWrapper je = jobOp.startJobAndWaitForResult("partitionRerun", origParams);
        long execId = je.getExecutionId();
        this.checkStepExecId(je, "step1", 2);
        AssertionUtils.assertWithMessage("Didn't fail as expected", BatchStatus.FAILED, je.getBatchStatus());
        Properties restartParams = new Properties();
        restartParams.setProperty("force.failure", "false");
        restartParams.setProperty("force.failure2", "true");
        TCKJobExecutionWrapper restartje = jobOp.restartJobAndWaitForResult(execId, restartParams);
        long restartExecId = restartje.getExecutionId();
        this.checkStepExecId(restartje, "step1", 1);
        AssertionUtils.assertWithMessage("Didn't fail as expected", BatchStatus.FAILED, jobOp.getJobExecution(restartExecId).getBatchStatus());
        Properties restartParams2 = new Properties();
        restartParams2.setProperty("force.failure", "false");
        restartParams2.setProperty("force.failure2", "false");
        TCKJobExecutionWrapper restartje2 = jobOp.restartJobAndWaitForResult(restartExecId, restartParams2);
        long restartExecId2 = restartje2.getExecutionId();
        AssertionUtils.assertWithMessage("Didn't complete successfully", BatchStatus.COMPLETED, jobOp.getJobExecution(restartExecId2).getBatchStatus());
        this.checkStepExecId(restartje2, "step1", 3);
    }

    private void checkStepExecId(JobExecution je, String stepName, int numPartitionResults) {
        List<StepExecution> stepExecs = jobOp.getStepExecutions(je.getExecutionId());
        Long stepExecId = null;
        for (StepExecution se : stepExecs) {
            if (!se.getStepName().equals(stepName)) continue;
            stepExecId = se.getStepExecutionId();
            break;
        }
        if (stepExecId == null) {
            throw new IllegalStateException("Didn't find step1 execution for job execution: " + je.getExecutionId());
        }
        String[] retvals = je.getExitStatus().split(",");
        AssertionUtils.assertWithMessage("Found different number of segments than expected in exit status string for job execution: " + je.getExecutionId(), numPartitionResults, retvals.length);
        for (int i = 0; i < retvals.length; ++i) {
            AssertionUtils.assertWithMessage("Did not return a number/numbers matching the stepExecId", (long)stepExecId, Long.parseLong(retvals[i]));
        }
    }
}

