/**
 * Copyright 2012, 2020 International Business Machines Corp. and others
 * <p>
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * <p>
 * SPDX-License-Identifier: Apache-2.0
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.partition.PartitionReducer;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;

@jakarta.inject.Named("myPartitionReducer")
public class MyPartitionReducer implements PartitionReducer {


    String history;

    @Inject
    StepContext stepCtx;

    @Inject
    JobContext jobCtx;

    @Override
    public void beginPartitionedStep() throws Exception {

        String exitStatus = stepCtx.getExitStatus();

        history = exitStatus + "Begin";

    }

    @Override
    public void beforePartitionedStepCompletion() throws Exception {
        String exitStatus = stepCtx.getExitStatus();

        stepCtx.setExitStatus(history + exitStatus + "Before");

    }

    @Override
    public void rollbackPartitionedStep() throws Exception {
        String exitStatus = stepCtx.getExitStatus();

        stepCtx.setExitStatus(history + exitStatus + "Rollback");

    }

    @Override
    public void afterPartitionedStepCompletion(PartitionStatus status) throws Exception {
        String exitStatus = stepCtx.getExitStatus();

        stepCtx.setExitStatus(exitStatus + "After");

        jobCtx.setExitStatus(stepCtx.getExitStatus());

    }


}
