/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentRestartUserData;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ChunkTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @Test
    public void testChunkNoProcessorDefined() throws Exception {
        String METHOD = "testChunkDefaultItemCount";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=40<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("readrecord.fail", "40");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkNoProcessorDefined.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkNoProcessorDefined", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "buffer size = 10", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkNullCheckpointInfo() throws Exception {
        String METHOD = "testChunkDefaultItemCount";
        try {
            Reporter.log((String)"Locate job XML file: nullChkPtInfo.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("nullChkPtInfo", null);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "checkpointInfo is null in reader.open...checkpointInfo is null in writer.open", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkArtifactInstanceUniqueness() throws Exception {
        String METHOD = "testChunkDefaultItemCount";
        try {
            Reporter.log((String)"Locate job XML file: uniqueInstanceTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("uniqueInstanceTest", null);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "nullChunkListenerChunkListenerStepListenerStepListenerJobListenerJobListener", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkOnErrorListener() throws Exception {
        String METHOD = "testChunkOnErrorListener";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=5<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "5");
            jobParams.put("app.writepoints", "0,10");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkListenerTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkListenerTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Chunk onError invoked", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRestartItemCount7() throws Exception {
        String METHOD = "testChunkRestartItemCount7";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.chunksize=7<p>");
            Reporter.log((String)"app.commitinterval=10<p>");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,7,14,21,28,30");
            jobParams.put("app.next.writepoints", "7,14,21,28,30");
            Reporter.log((String)"Locate job XML file: chunkStopOnEndOn.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkStopOnEndOn", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.chunksize=7<p>");
            Reporter.log((String)"app.commitinterval=10<p>");
            Properties restartJobParameters = new Properties();
            restartJobParameters.put("execution.number", "2");
            restartJobParameters.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "7");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with executionId: " + lastExecutionId + "<p>"));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRestartItemCount10() throws Exception {
        String METHOD = "testChunkRestartItemCount10";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.next.writepoints=0,5,10,15,20,25,30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,10,20,30");
            jobParams.put("app.next.writepoints", "10,20,30");
            Reporter.log((String)"Locate job XML file: chunkrestartCheckpt10.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkrestartCheckpt10", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            Properties restartJobParameters = new Properties();
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            restartJobParameters.put("execution.number", "2");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "10");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + "<p>"));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRestartChunk5() throws Exception {
        String METHOD = "testChunkRestartChunk5";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,3,6,9,12,15,18,21,24,27,30<p>");
            Reporter.log((String)"app.next.writepoints=9,12,15,18,21,24,27,30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval3.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResul for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval3", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            Properties restartJobParameters = new Properties(jobParams);
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            restartJobParameters.put("execution.number", "2");
            restartJobParameters.put("app.checkpoint.position", "10");
            restartJobParameters.put("app.arraysize", "30");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + "<p>"));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, restartJobParameters);
            lastExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkDefaultItemCount() throws Exception {
        String METHOD = "testChunkDefaultItemCount";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=40<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("readrecord.fail", "40");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunksizeDEFAULTcommitIntervalDEFAULT.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksizeDEFAULTcommitIntervalDEFAULT", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "buffer size = 10", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRestartCustomCheckpoint() throws Exception {
        String METHOD = "testChunkRestartCustomCheckpoint";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,4,9,13,15,20,22,27,30<p>");
            Reporter.log((String)"app.next.writepoints=9,13,15,20,22,27,30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,4,9,13,15,20,22,27,30");
            jobParams.put("app.next.writepoints", "9,13,15,20,22,27,30");
            Reporter.log((String)"Locate job XML file: chunkCustomCheckpoint.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkCustomCheckpoint", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            Properties restartJobParameters = new Properties(jobParams);
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=9,13,15,20,22,27,30<p>");
            restartJobParameters.put("execution.number", "2");
            restartJobParameters.put("app.checkpoint.position", "9");
            restartJobParameters.put("app.arraysize", "30");
            restartJobParameters.put("app.writepoints", "9,13,15,20,22,27,30");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + "<p>"));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, restartJobParameters);
            lastExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkTimeBasedDefaultCheckpoint() throws Exception {
        String METHOD = "testChunkTimeBasedDefaultCheckpoint";
        String DEFAULT_SLEEP_TIME = "500";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=31<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkTimeBasedDefaultCheckpoint.sleep", DEFAULT_SLEEP_TIME));
            Reporter.log((String)"Locate job XML file: chunkTimeBasedDefaultCheckpoint.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedDefaultCheckpoint", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            String exitStatus = execution1.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #1", exitStatus.equals("TRUE: 0") || exitStatus.equals("TRUE: 1"));
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkTimeBasedTimeLimit0() throws Exception {
        String METHOD = "testChunkTimeBasedDefaultCheckpoint";
        String DEFAULT_SLEEP_TIME = "500";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=31<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkTimeBasedTimeLimit0.sleep", DEFAULT_SLEEP_TIME));
            Reporter.log((String)"Locate job XML file: chunkTimeLimit0.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeLimit0", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            String exitStatus = execution1.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #1", exitStatus.equals("TRUE: 0") || exitStatus.equals("TRUE: 1"));
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkTimeBased10Seconds() throws Exception {
        String METHOD = "testChunkTimeBased10Seconds";
        String DEFAULT_SLEEP_TIME = "500";
        try {
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkTimeBased10Seconds.sleep", DEFAULT_SLEEP_TIME));
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedCheckpoint", jobParams);
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            String exitStatus = execution1.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #1", exitStatus.equals("TRUE: 9") || exitStatus.equals("TRUE: 10") || exitStatus.equals("TRUE: 11"));
            Reporter.log((String)("exit status = " + execution1.getExitStatus() + "<p>"));
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRestartTimeBasedCheckpoint() throws Exception {
        String METHOD = "testChunkRestartTimeBasedCheckpoint";
        String DEFAULT_SLEEP_TIME = "500";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkRestartTimeBasedCheckpoint.sleep", DEFAULT_SLEEP_TIME));
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedCheckpoint", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FALSE: 0", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + "<p>"));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            String exitStatus = exec.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #2", exitStatus.equals("TRUE: 9") || exitStatus.equals("TRUE: 10") || exitStatus.equals("TRUE: 11"));
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRestartTimeBasedDefaultCheckpoint() throws Exception {
        String METHOD = "testChunkRestartTimeBasedDefaultCheckpoint";
        String DEFAULT_SLEEP_TIME = "500";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=2<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "2");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkRestartTimeBasedDefaultCheckpoint.sleep", DEFAULT_SLEEP_TIME));
            Reporter.log((String)"Locate job XML file: chunkTimeBasedDefaultCheckpoint.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedDefaultCheckpoint", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "TRUE: 0", execution1.getExitStatus());
            JobInstance jobInstance = jobOp.getJobInstance(execution1.getExecutionId());
            long jobInstanceId = jobInstance.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + "<p>"));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(exec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "TRUE: 0", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    @Disabled(value="Bug 5403.  Decided to exclude this test. Hopefully will introduce a modified version in 1.1")
    public void testChunkSkipMultipleExceptions() throws Exception {
        String METHOD = "testChunkSkipRead";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipMultipleExceptions.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipMultipleExceptions", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipRead() throws Exception {
        String METHOD = "testChunkSkipRead";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipInitialTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipInitialTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipProcess() throws Exception {
        String METHOD = "testChunkSkipProcess";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"processrecord.fail=7,13<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipInitialTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipInitialTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipProcessListener: GOOD STATUS, GOOD OBJ PASSED", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipWrite() throws Exception {
        String METHOD = "testChunkSkipWrite";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"writerecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipInitialTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipInitialTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipWriteListener: GOOD STATUS, GOOD OBJS PASSED IN", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipOnError() throws Exception {
        String METHOD = "testChunkSkipOnError";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipOnErrorTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipOnErrorTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemReadListenerImpl.onReadError", execution1.getExitStatus());
            jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"processrecord.fail=7,13<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipOnErrorTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("chunkSkipOnErrorTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution2.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution2.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemProcessListenerImpl.onProcessError", execution2.getExitStatus());
            jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"writerecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipOnErrorTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("chunkSkipOnErrorTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution3.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution3.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemWriteListenerImpl.onWriteError", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRetryOnError() throws Exception {
        String METHOD = "testChunkRetryOnError";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkRetryOnError.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkRetryOnError", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemReadListenerImpl.onReadError", execution1.getExitStatus());
            jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"processrecord.fail=7,13<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkRetryOnError.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("chunkRetryOnError", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution2.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution2.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemProcessListenerImpl.onProcessError", execution2.getExitStatus());
            jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"writerecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkRetryOnError.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("chunkRetryOnError", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution3.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution3.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemWriteListenerImpl.onWriteError", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipReadExceedSkip() throws Exception {
        String METHOD = "testChunkSkipReadExceedSkip";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"processrecord.fail=1,2<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,2");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipExceededTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipExceededTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipProcessExceedSkip() throws Exception {
        String METHOD = "testChunkSkipProcessExceedSkip";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"processrecord.fail=5,7<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "5,7");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipExceededTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipExceededTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipProcessListener: GOOD STATUS, GOOD OBJ PASSED", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipWriteExceedSkip() throws Exception {
        String METHOD = "testChunkSkipWriteExceedSkip";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"writerecord.fail=2,8<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "2,8");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipExceededTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipExceededTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipWriteListener: GOOD STATUS, GOOD OBJS PASSED IN", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkSkipReadNoSkipChildEx() throws Exception {
        String METHOD = "testChunkSkipReadNoSkipChildEx";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"writerecord.fail=1,2,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,2,3");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkSkipNoSkipChildExTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipNoSkipChildExTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkRetryRead() throws Exception {
        String METHOD = "testChunkRetryRead";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"writerecord.fail=8,13,22<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkRetryInitialTest.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkRetryInitialTest", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "COMPLETED", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    @Disabled(value="Bug 5403.  Decided to exclude this test. Hopefully will introduce a modified version in 1.1")
    public void testChunkRetryMultipleExceptions() throws Exception {
        String METHOD = "testChunkRetryMultipleExceptions";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3,5");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: chunkRetryMultipleExceptions.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkRetryMultipleExceptions", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyMultipleExceptionsRetryReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkItemListeners() throws Exception {
        String METHOD = "testChunkItemListeners";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=31<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.listenertest=READ<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.listenertest", "READ");
            Reporter.log((String)"Locate job XML file: testListeners.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testListeners", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", "MyItemReadListenerImpl: GOOD STATUS", execution1.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=31<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.listenertest=PROCESS<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.listenertest", "PROCESS");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #2<p>");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("testListeners", jobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", "MyItemProcessListenerImpl: GOOD STATUS", execution2.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #3:<p>");
            jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=31<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.listenertest=WRITE<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.listenertest", "WRITE");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #3<p>");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("testListeners", jobParams);
            Reporter.log((String)("execution #3 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #3 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", "MyItemWriteListener: GOOD STATUS", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testChunkItemListenersOnError() throws Exception {
        String METHOD = "testChunkItemListeners";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"read.fail.immediate=true<p>");
            jobParams.put("read.fail.immediate", "true");
            Reporter.log((String)"Locate job XML file: testListeners.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testListenersOnError", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", "MyItemReadListenerImpl.onReadError", execution1.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            jobParams = new Properties();
            Reporter.log((String)"process.fail.immediate=true<p>");
            jobParams.put("process.fail.immediate", "true");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #2<p>");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("testListenersOnError", jobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", BatchStatus.FAILED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", "MyItemProcessListenerImpl.onProcessError", execution2.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #3:<p>");
            jobParams = new Properties();
            Reporter.log((String)"write.fail.immediate=true<p>");
            jobParams.put("write.fail.immediate", "true");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #3<p>");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("testListenersOnError", jobParams);
            Reporter.log((String)("execution #3 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #3 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", BatchStatus.FAILED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", "MyItemWriteListenerImpl.onWriteError", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testUserDataIsPersistedAfterCheckpoint() throws Exception {
        String METHOD = "testChunkRestartItemCount10";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.next.writepoints=0,5,10,15,20,25,30<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,10,20,30");
            jobParams.put("app.next.writepoints", "10,20,30");
            Reporter.log((String)"Locate job XML file: chunkrestartCheckpt10.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkrestartCheckpt10", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(execution1.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            List<StepExecution> stepExecs = jobOp.getStepExecutions(execution1.getExecutionId());
            MyPersistentRestartUserData persistedStepData = null;
            for (StepExecution stepExec : stepExecs) {
                if (!stepExec.getStepName().equals("step1")) continue;
                persistedStepData = (MyPersistentRestartUserData)stepExec.getPersistentUserData();
                break;
            }
            AssertionUtils.assertWithMessage("Testing execution #1", 1, persistedStepData.getExecutionNumber());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    private void showStepState(StepExecution step) {
        Reporter.log((String)"---------------------------<p>");
        Reporter.log((String)("getJobExecutionId(): " + step.getStepExecutionId() + " - "));
        Metric[] metrics = step.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            Reporter.log((String)(String.valueOf(metrics[i].getType()) + ": " + metrics[i].getValue() + " - "));
        }
        Reporter.log((String)("getStartTime(): " + String.valueOf(step.getStartTime()) + " - "));
        Reporter.log((String)("getEndTime(): " + String.valueOf(step.getEndTime()) + " - "));
        Reporter.log((String)("getBatchStatus(): " + String.valueOf(step.getBatchStatus()) + " - "));
        Reporter.log((String)("getExitStatus(): " + step.getExitStatus()));
        Reporter.log((String)"---------------------------<p>");
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

