/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.w3c.dom.Node;

class XPathDomNodeList<E extends DomNode>
extends AbstractList<E>
implements DomNodeList<E>,
Serializable {
    private String xpath_;
    private DomNode node_;
    private Transformer transformer_;
    private List<Object> cachedElements_;

    public XPathDomNodeList(DomNode node, String xpath) {
        this(node, xpath, NOPTransformer.INSTANCE);
    }

    public XPathDomNodeList(DomNode node, String xpath, Transformer transformer) {
        if (node != null) {
            this.node_ = node;
            this.xpath_ = xpath;
            this.transformer_ = transformer;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
    }

    private List<Object> getNodes() {
        if (this.cachedElements_ == null) {
            this.cachedElements_ = this.node_ == null ? new ArrayList<Object>() : XPathUtils.getByXPath(this.node_, this.xpath_, null);
        }
        return this.cachedElements_;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public int getLength() {
        return this.getNodes().size();
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.transformer_.transform(this.getNodes().get(index));
    }

    @Override
    public E get(int index) {
        return (E)((DomNode)this.getNodes().get(index));
    }

    @Override
    public String toString() {
        return "XPathDomNodeList[" + this.xpath_ + "]";
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private transient WeakReference<XPathDomNodeList<?>> nodeList_;

        private DomHtmlAttributeChangeListenerImpl(XPathDomNodeList<?> nodeList) {
            this.nodeList_ = new WeakReference(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            this.clearCache();
        }

        private void clearCache() {
            XPathDomNodeList nodes = (XPathDomNodeList)this.nodeList_.get();
            if (null != nodes) {
                nodes.cachedElements_ = null;
            }
        }
    }
}

