/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.expressionfactory;

import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void newInstanceTest() throws Exception {
        try {
            ExpressionFactory.newInstance();
            ExpressionFactory.newInstance(null);
            Properties props = new Properties();
            props.setProperty("jakarta.el.cacheSize", "128M");
            ExpressionFactory.newInstance((Properties)props);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void createValueExpressionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${employee.lastname}", "#{employee.lastname}", "John Doe", "${employee.firstname}${employee.lastname}", "#{employee.firstname}#{employee.lastname}", "Name: ${employee.firstname}${employee.lastname}", "Name: #{employee.firstname}#{employee.lastname}"};
        ValueExpression vexp = null;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    vexp = expFactory.createValueExpression((ELContext)context, exprStr[i], Object.class);
                }
                catch (NullPointerException npe) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Test FAILED" + exprStr[i]);
                    ELTestUtil.printStackTrace(npe);
                    continue;
                }
                catch (ELException ee) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Test FAILED" + exprStr[i]);
                    ELTestUtil.printStackTrace(ee);
                    continue;
                }
                if (vexp.getExpressionString().equals(exprStr[i])) continue;
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Failed. Expression string mismatch.");
                logger.log(System.Logger.Level.ERROR, "Expected: " + exprStr[i]);
                logger.log(System.Logger.Level.ERROR, "Received: " + vexp.getExpressionString());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void createValueExpression2Test() throws Exception {
        boolean pass = true;
        ObjectAndType[] testCases = new ObjectAndType[]{new ObjectAndType("some string", String.class), new ObjectAndType(null, String.class), new ObjectAndType(1, String.class), new ObjectAndType(1.5, Integer.class), new ObjectAndType("10000", Long.class), new ObjectAndType(1, Boolean.class), new ObjectAndType(Boolean.TRUE, Character.class), new ObjectAndType(1, Class.class)};
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        for (int i = 0; i < testCases.length; ++i) {
            try {
                expFactory.createValueExpression(testCases[i].obj, testCases[i].type);
                continue;
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Exception: Test Case " + i);
                ELTestUtil.printStackTrace(e);
            }
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void createValueExpressionELExceptionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${employee.lastname", "#{employee[lastname}", "${ 5 ! 3 }", "${ 5 + }", "${employee.firstname}#{employee.lastname}", "#{employee.firstname}${employee.lastname}", "Name: ${employee.firstname}#{employee.lastname}", "Name: #{employee.firstname}${employee.lastname}"};
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    expFactory.createValueExpression((ELContext)context, exprStr[i], Object.class);
                }
                catch (ELException ee) {
                    continue;
                }
                catch (NullPointerException npe) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Test FAILED" + exprStr[i]);
                    ELTestUtil.printStackTrace(npe);
                    continue;
                }
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Failed. No ELException thrown when calling");
                logger.log(System.Logger.Level.ERROR, "createValueExpression() with parameter " + exprStr[i]);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void createMethodExpressionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${add}", "${vect.add}", "${vect[add]}", "#{add}", "#{vect.add}", "#{vect[add]}", "add"};
        MethodExpression mexp = null;
        Class[] paramTypes = new Class[]{};
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    mexp = expFactory.createMethodExpression((ELContext)context, exprStr[i], Object.class, paramTypes);
                }
                catch (NullPointerException npe) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Test FAILED" + exprStr[i]);
                    ELTestUtil.printStackTrace(npe);
                    continue;
                }
                catch (ELException ee) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Test FAILED" + exprStr[i]);
                    ELTestUtil.printStackTrace(ee);
                    continue;
                }
                if (mexp.getExpressionString().equals(exprStr[i])) continue;
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Failed. Expression string mismatch.");
                logger.log(System.Logger.Level.ERROR, "Expected: " + exprStr[i]);
                logger.log(System.Logger.Level.ERROR, "Received: " + mexp.getExpressionString());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void createMethodExpressionELExceptionTest() throws Exception {
        boolean pass = true;
        String[] exprStr = new String[]{"${vect.add", "#{vect[add}", "${ 5 }", "${ -A }", "${ A + B }", "${vect.remove}${vect.add}", "#{vect.remove}#{vect.add}", "${vect.remove}#{vect.add}", "#{vect.remove}${vect.add}"};
        Class[] paramTypes = new Class[]{};
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            for (int i = 0; i < exprStr.length; ++i) {
                try {
                    expFactory.createMethodExpression((ELContext)context, exprStr[i], Object.class, paramTypes);
                }
                catch (ELException ee) {
                    continue;
                }
                catch (NullPointerException npe) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Test FAILED" + exprStr[i]);
                    ELTestUtil.printStackTrace(npe);
                    continue;
                }
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Failed. No ELException thrown when calling");
                logger.log(System.Logger.Level.ERROR, "createMethodExpression() with parameter " + exprStr[i]);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void createExpressionNPETest() throws Exception {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        SimpleELContext context = new SimpleELContext();
        logger.log(System.Logger.Level.INFO, "Testing: ELContext.createValueExpression(context, function, null)");
        ELTestUtil.checkForNPE(expFactory, "createValueExpression", new Class[]{ELContext.class, String.class, Class.class}, new Object[]{context, "function", null});
        logger.log(System.Logger.Level.INFO, "Testing: ELContext.createValueExpression(instance, null)");
        ELTestUtil.checkForNPE(expFactory, "createValueExpression", new Class[]{Object.class, Class.class}, new Object[]{"function", null});
        logger.log(System.Logger.Level.INFO, "Testing: ELContext.createMethodExpression(context, instance, returnTypes, null)");
        ELTestUtil.checkForNPE(expFactory, "createMethodExpression", new Class[]{ELContext.class, String.class, Class.class, Class[].class}, new Object[]{context, "${foo}", Object.class, null});
    }

    @Test
    public void coerceToTypeTest() throws Exception {
        boolean pass = true;
        ObjectAndType[] testCases = new ObjectAndType[]{new ObjectAndType("some string", String.class), new ObjectAndType(null, String.class), new ObjectAndType(1, String.class), new ObjectAndType(1.5, String.class), new ObjectAndType(Boolean.FALSE, String.class), new ObjectAndType(1.5, Integer.class), new ObjectAndType(1, Float.class), new ObjectAndType("10000", Long.class), new ObjectAndType("no value", Boolean.class), new ObjectAndType(null, null)};
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        for (int i = 0; i < testCases.length; ++i) {
            try {
                Object coercedObj = expFactory.coerceToType(testCases[i].obj, testCases[i].type);
                if (coercedObj == null) {
                    if (testCases[i].type == null || testCases[i].obj == null) continue;
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Failed: Test Case " + i);
                    continue;
                }
                if (ExprEval.compareClass(coercedObj, testCases[i].type)) continue;
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Failed: Test Case " + i);
                continue;
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Exception: Test Case " + i);
                ELTestUtil.printStackTrace(e);
            }
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void coerceToTypeELExceptionTest() throws Exception {
        boolean pass = true;
        ObjectAndType[] testCases = new ObjectAndType[]{new ObjectAndType(1, Boolean.class), new ObjectAndType(Boolean.FALSE, Long.class), new ObjectAndType(Boolean.TRUE, Character.class), new ObjectAndType(true, Float.class), new ObjectAndType("non-numeric string", Long.class), new ObjectAndType(1, Class.class)};
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        for (int i = 0; i < testCases.length; ++i) {
            try {
                expFactory.coerceToType(testCases[i].obj, testCases[i].type);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Test Case " + i + " did not cause an exception");
                continue;
            }
            catch (ELException elx) {
                pass = true;
                continue;
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Test Case " + i + " threw an exception");
                logger.log(System.Logger.Level.ERROR, "but it was not an ELException");
                ELTestUtil.printStackTrace(e);
            }
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    private static class ObjectAndType {
        public Object obj;
        public Class<?> type;

        public ObjectAndType(Object obj, Class<?> type) {
            this.obj = obj;
            this.type = type;
        }
    }
}

