/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.fmt.i18n.resourcelookup;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_fmt_reslook_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_fmt_reslook_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_fmt_reslook_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/formatBundleResourceLookup.jsp")), "formatBundleResourceLookup.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/formatSetBundleResourceLookup.jsp")), "formatSetBundleResourceLookup.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveResourceBundleLookupTest() throws Exception {
        TEST_PROPS.setProperty("testname", "positiveResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatBundleResourceLookup.jsp?res=AlgoResources2&fall=fr_CA");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: en-GB, fr-CA");
        TEST_PROPS.setProperty("expected_headers", "message: en_GB message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatBundleResourceLookup.jsp?res=AlgoResources3&fall=en");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: de, fr");
        TEST_PROPS.setProperty("expected_headers", "message: en message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatBundleResourceLookup.jsp?res=AlgoResources4&fall=en");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: ja, en-GB, en-US, en-CA, fr");
        TEST_PROPS.setProperty("expected_headers", "message: en_GB message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatBundleResourceLookup.jsp?res=AlgoResources5&fall=en");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: fr, sw");
        TEST_PROPS.setProperty("expected_headers", "message: sw message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatBundleResourceLookup.jsp?res=AlgoResources&fall=ja");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: ja");
        TEST_PROPS.setProperty("expected_headers", "message: default message");
        this.invoke();
    }

    @Test
    public void positiveResourceSetBundleLookupTest() throws Exception {
        TEST_PROPS.setProperty("testname", "positiveSetResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatSetBundleResourceLookup.jsp?res=AlgoResources2&fall=fr_CA");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: en-GB, fr-CA");
        TEST_PROPS.setProperty("expected_headers", "message: en_GB message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveSetResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatSetBundleResourceLookup.jsp?res=AlgoResources3&fall=en");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: de, fr");
        TEST_PROPS.setProperty("expected_headers", "message: en message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveSetResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatSetBundleResourceLookup.jsp?res=AlgoResources4&fall=en");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: ja, en-GB, en-US, en-CA, fr");
        TEST_PROPS.setProperty("expected_headers", "message: en_GB message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveSetResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatSetBundleResourceLookup.jsp?res=AlgoResources5&fall=en");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: fr, sw");
        TEST_PROPS.setProperty("expected_headers", "message: sw message");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveSetResourceBundleLookupTest");
        TEST_PROPS.setProperty("request", "formatSetBundleResourceLookup.jsp?res=AlgoResources&fall=ja");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: ja");
        TEST_PROPS.setProperty("expected_headers", "message: default message");
        this.invoke();
    }
}

