/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms;

import jakarta.annotation.PostConstruct;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms.Missile;

@Interceptor
@Missile
public class MissileInterceptor {
    static final AtomicBoolean METHOD_INTERCEPTED = new AtomicBoolean(false);
    public static boolean lifecycleCallbackIntercepted = false;
    public static boolean aroundConstructInterceptorCalled = false;

    @AroundInvoke
    public Object alwaysReturnThis(InvocationContext ctx) throws Exception {
        METHOD_INTERCEPTED.set(true);
        return ctx.proceed();
    }

    @AroundConstruct
    public Object aroundConstruct(InvocationContext ctx) throws Exception {
        aroundConstructInterceptorCalled = true;
        return ctx.proceed();
    }

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        lifecycleCallbackIntercepted = true;
        try {
            ctx.proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void reset() {
        METHOD_INTERCEPTED.set(false);
        lifecycleCallbackIntercepted = false;
        aroundConstructInterceptorCalled = false;
    }
}

