/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.IEntry;
import org.eclipse.january.form.IUpdateable;
import org.eclipse.january.form.IUpdateableListener;

@XmlRootElement(name="DataComponent")
public class DataComponent
extends ICEObject
implements Component,
IUpdateableListener {
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    private ArrayList<IEntry> entries = new ArrayList();

    public void addEntry(IEntry newEntry) {
        if (newEntry != null) {
            this.entries.add(newEntry);
            newEntry.register(this);
            this.notifyListeners();
        }
    }

    public void addEntry(IEntry newEntry, String ... parentNames) {
    }

    public void clearEntries() {
        if (!this.entries.isEmpty()) {
            this.entries.clear();
            this.notifyListeners();
        }
    }

    public void deleteEntry(String entryName) {
        int i = 0;
        if (entryName != null) {
            i = 0;
            while (i < this.entries.size()) {
                if (this.entries.get(i).getName().equals(entryName)) {
                    this.entries.remove(i);
                }
                ++i;
            }
            this.notifyListeners();
        }
    }

    public IEntry retrieveEntry(String entryName) {
        for (IEntry j : this.entries) {
            if (!j.getName().equals(entryName)) continue;
            return j;
        }
        return null;
    }

    public ArrayList<IEntry> retrieveReadyEntries() {
        ArrayList<IEntry> readyEntryList = new ArrayList<IEntry>();
        for (IEntry i : this.entries) {
            if (!i.isReady()) continue;
            readyEntryList.add(i);
        }
        return readyEntryList;
    }

    public ArrayList<IEntry> retrieveAllEntries() {
        return this.entries;
    }

    public boolean contains(String entryName) {
        for (IEntry i : this.entries) {
            if (!i.getName().equals(entryName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object otherDataComponent) {
        if (this == otherDataComponent) {
            return true;
        }
        if (otherDataComponent == null || !(otherDataComponent instanceof DataComponent) || !super.equals(otherDataComponent)) {
            return false;
        }
        DataComponent castedComponent = (DataComponent)otherDataComponent;
        for (IEntry entry : this.entries) {
            if (castedComponent.entries.contains(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 9;
        hash = 31 * hash + super.hashCode();
        for (IEntry entry : this.entries) {
            hash = 31 * hash + entry.hashCode();
        }
        return hash;
    }

    public void copy(DataComponent otherDataComponent) {
        if (otherDataComponent != null) {
            super.copy(otherDataComponent);
            this.entries.clear();
            int i = 0;
            while (i < otherDataComponent.entries.size()) {
                this.entries.add((IEntry)otherDataComponent.entries.get(i).clone());
                ++i;
            }
            this.notifyListeners();
        }
    }

    @Override
    public Object clone() {
        DataComponent dataComponent = new DataComponent();
        dataComponent.copy(this);
        return dataComponent;
    }

    @Override
    public void update(String updatedKey, String newValue) {
        for (IEntry i : this.entries) {
            i.update(updatedKey, newValue);
        }
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void update(IUpdateable component) {
        this.notifyListeners();
    }
}

