/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.Stack;
import org.eclipse.january.form.AbstractTreeCompositeIterator;
import org.eclipse.january.form.TreeComposite;

public class PreOrderTreeCompositeIterator
extends AbstractTreeCompositeIterator {
    private final Stack<TreeComposite> stack = new Stack();

    public PreOrderTreeCompositeIterator(TreeComposite root) {
        super(root != null ? root : new TreeComposite());
        if (root == null) {
            throw new IllegalArgumentException("PreOrderTreeCompositeIterator error: Root cannot be null.");
        }
        this.stack.push(root);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public TreeComposite next() {
        TreeComposite next = super.next();
        next = this.stack.pop();
        int i = next.getNumberOfChildren() - 1;
        while (i >= 0) {
            this.stack.push(next.getChildAtIndex(i));
            --i;
        }
        return next;
    }
}

