/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form.emf;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.january.form.DataComponent;
import org.eclipse.january.form.TreeComposite;
import org.eclipse.january.form.emf.EMFEntry;

@XmlRootElement(name="EMFTreeComposite")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EMFTreeComposite
extends TreeComposite {
    @XmlTransient
    private EObject ecoreNode;
    @XmlTransient
    private EClass ecoreNodeMetaData;

    public EMFTreeComposite() {
        this.setName("Null Constructed EMFTreeComposite");
        this.setDescription(this.toString());
    }

    public EMFTreeComposite(EClass eClass) {
        if (eClass != null) {
            this.ecoreNodeMetaData = eClass;
            this.ecoreNode = EcoreUtil.create((EClass)this.ecoreNodeMetaData);
            this.setName(this.ecoreNodeMetaData.getName());
            this.setDescription(this.toString());
            this.createActiveDataNode();
        }
    }

    public EMFTreeComposite(EObject treeNode) {
        this.ecoreNode = treeNode;
        this.ecoreNodeMetaData = this.ecoreNode.eClass();
        this.setName(this.ecoreNodeMetaData.getName());
        this.setDescription(this.toString());
        this.createActiveDataNode();
    }

    private void createActiveDataNode() {
        int id = 0;
        DataComponent data = new DataComponent();
        for (EAttribute a : this.ecoreNodeMetaData.getEAllAttributes()) {
            if ("mixed".equals(a.getName())) continue;
            EMFEntry entry = new EMFEntry(a, this.ecoreNode);
            entry.setId(id++);
            data.addEntry(entry);
        }
        data.setName(String.valueOf(this.ecoreNodeMetaData.getName()) + " Data");
        data.setDescription("Please set all required data pertinent to " + this.ecoreNodeMetaData.getName() + ".");
        this.allowActiveDataNodes(true);
        this.addComponent(data);
        this.setActiveDataNode(data);
    }

    @Override
    public ArrayList<TreeComposite> getChildExemplars() {
        ArrayList<TreeComposite> exemplars = new ArrayList<TreeComposite>();
        boolean childExists = false;
        for (EReference exemplar : this.ecoreNodeMetaData.getEAllReferences()) {
            if ("EStringToStringMapEntry".equals(exemplar.getEReferenceType().getName())) continue;
            int upperBound = exemplar.getUpperBound();
            if (upperBound == -1) {
                exemplars.add(new EMFTreeComposite(exemplar.getEReferenceType()));
                continue;
            }
            if (upperBound > 1) continue;
            for (TreeComposite currentChild : this.children) {
                if (!currentChild.getName().equals(exemplar.getEReferenceType().getName())) continue;
                childExists = true;
                break;
            }
            if (childExists) continue;
            exemplars.add(new EMFTreeComposite(exemplar.getEReferenceType()));
        }
        return exemplars;
    }

    public EObject getEcoreNode() {
        return this.ecoreNode;
    }

    public EClass getEcoreMetaData() {
        return this.ecoreNodeMetaData;
    }

    @Override
    public void setNextChild(TreeComposite cNode) {
        int currentSize = this.children.size();
        super.setNextChild(cNode);
        if (currentSize == this.children.size()) {
            this.logger.info("Could not add " + cNode.getName() + " as child of " + this.getName());
            return;
        }
        EMFTreeComposite castedTree = (EMFTreeComposite)cNode;
        EReference exemplar = this.getEReferenceExemplar(castedTree.getName());
        if (exemplar != null) {
            if (exemplar.getUpperBound() != -1) {
                this.ecoreNode.eSet((EStructuralFeature)exemplar, (Object)castedTree.ecoreNode);
            } else {
                ((EList)this.ecoreNode.eGet((EStructuralFeature)exemplar)).add((Object)castedTree.ecoreNode);
            }
        }
        castedTree.updateContainingNode(castedTree.ecoreNode);
    }

    private EReference getEReferenceExemplar(String treeName) {
        for (EReference ref : this.ecoreNodeMetaData.getEReferences()) {
            if (!treeName.equals(ref.getEReferenceType().getName())) continue;
            return ref;
        }
        return null;
    }

    @Override
    protected boolean checkExemplars(TreeComposite cNode) {
        for (TreeComposite exemplar : this.getChildExemplars()) {
            if (cNode.getName().equals("DefinitionType")) {
                this.logger.info("Exemplar: " + exemplar.getName());
            }
            if (!cNode.getName().equals(exemplar.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChildExemplars() {
        return !this.getChildExemplars().isEmpty();
    }

    public void updateContainingNode(EObject newEcoreChild) {
        DataComponent dataComp = (DataComponent)this.getDataNodes().get(0);
        dataComp.clearEntries();
        this.ecoreNode = newEcoreChild;
        for (EAttribute a : this.ecoreNode.eClass().getEAllAttributes()) {
            dataComp.addEntry(new EMFEntry(a, this.ecoreNode));
        }
        this.allowActiveDataNodes(true);
        this.setActiveDataNode(dataComp);
    }

    @Override
    public void removeChild(TreeComposite cNode) {
        EStructuralFeature childStructuralFeature = null;
        int currentSize = this.children.size();
        super.removeChild(cNode);
        if (currentSize != this.children.size()) {
            for (EStructuralFeature feature : this.ecoreNodeMetaData.getEStructuralFeatures()) {
                if (!feature.getEType().getName().equals(cNode.getName())) continue;
                childStructuralFeature = feature;
            }
            ((EList)this.ecoreNode.eGet(childStructuralFeature)).remove((Object)((EMFTreeComposite)cNode).getEcoreNode());
        }
    }

    @Override
    public boolean equals(Object otherTreeComposite) {
        return super.equals(otherTreeComposite);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setECoreNodeMetaData(EClass metaData) {
        this.ecoreNodeMetaData = metaData;
    }

    public void copy(EMFTreeComposite otherTreeComposite) {
        if (otherTreeComposite == null) {
            return;
        }
        if (otherTreeComposite.ecoreNodeMetaData != null) {
            this.ecoreNodeMetaData = otherTreeComposite.ecoreNodeMetaData;
            this.ecoreNode = EcoreUtil.create((EClass)this.ecoreNodeMetaData);
        }
        super.copy(otherTreeComposite, true);
    }

    @Override
    public Object clone() {
        EMFTreeComposite emfTreeComposite = new EMFTreeComposite();
        emfTreeComposite.copy(this);
        return emfTreeComposite;
    }
}

