/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.InterpolatorUtils;
import org.eclipse.january.dataset.Maths;
import org.junit.Assert;
import org.junit.Test;

public class InterpolatorUtilsTest {
    @Test
    public void test() {
        Dataset im = DatasetFactory.createRange((double)0.0, (double)10000.0, (double)1.0, (int)5);
        im = im.reshape(new int[]{100, 100});
        Dataset off = Maths.sin((Object)DatasetFactory.createRange((double)0.0, (double)10.0, (double)0.1, (int)5));
        Dataset axis = DatasetFactory.createRange((double)-5.0, (double)5.0, (double)0.1, (int)5);
        Dataset newaxis = DatasetFactory.createRange((double)-10.0, (double)10.0, (double)0.1, (int)5);
        Dataset output = InterpolatorUtils.remapOneAxis((Dataset)im, (int)0, (Dataset)off, (Dataset)axis, (Dataset)newaxis);
        Assert.assertEquals((String)"Coordinate incorrect", (double)1468.249, (double)output.getDouble(62, 29), (double)0.1);
        Assert.assertEquals((String)"Coordinate incorrect", (double)7124.733, (double)output.getDouble(127, 56), (double)0.1);
        Assert.assertEquals((String)"Coordinate incorrect", (double)Double.NaN, (double)output.getDouble(179, 33), (double)0.1);
        Assert.assertEquals((String)"Coordinate incorrect", (double)9600.669, (double)output.getDouble(144, 2), (double)0.1);
        Assert.assertEquals((String)"Coordinate incorrect", (double)379.814, (double)output.getDouble(53, 63), (double)0.1);
        Assert.assertEquals((String)"Coordinate incorrect", (double)225.239, (double)output.getDouble(54, 97), (double)0.1);
        Assert.assertEquals((String)"Coordinate incorrect", (double)7118.775, (double)output.getDouble(120, 94), (double)0.1);
    }
}

