/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import org.eclipse.january.MetadataException;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.metadata.AxesMetadata;
import org.eclipse.january.metadata.DimensionMetadata;
import org.eclipse.january.metadata.DynamicConnectionInfo;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.IExtendedMetadata;
import org.eclipse.january.metadata.IMetadata;
import org.eclipse.january.metadata.MaskMetadata;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.OriginMetadata;
import org.eclipse.january.metadata.PeemMetadata;
import org.eclipse.january.metadata.StatisticsMetadata;
import org.eclipse.january.metadata.UnitMetadata;
import org.eclipse.january.metadata.internal.ErrorMetadataImpl;
import org.eclipse.january.metadata.internal.OriginMetadataImpl;
import org.junit.Assert;
import org.junit.Test;

public class MetadataFactoryTest {
    static final Class[] types = new Class[]{IMetadata.class, ErrorMetadata.class, AxesMetadata.class, DimensionMetadata.class, MaskMetadata.class, OriginMetadata.class, PeemMetadata.class, StatisticsMetadata.class, UnitMetadata.class};
    static final Object[][] arguments;

    static {
        Object[][] objectArrayArray = new Object[9][];
        objectArrayArray[0] = new Object[]{new HashMap()};
        objectArrayArray[1] = new Object[]{DatasetFactory.ones((int[])new int[]{2, 3})};
        objectArrayArray[2] = new Object[]{4};
        objectArrayArray[3] = new Object[]{new int[]{2, 256}, new int[]{-1, 256}, new int[]{1, 64}};
        objectArrayArray[4] = new Object[]{DatasetFactory.ones((int[])new int[]{3, 2})};
        Object[] objectArray = new Object[5];
        objectArray[2] = new int[]{1, 2};
        objectArray[3] = "/file/path";
        objectArray[4] = "/data/path";
        objectArrayArray[5] = objectArray;
        objectArrayArray[6] = new Object[]{new double[]{-3.0, 2.5}, 1.25, 3.14};
        objectArrayArray[7] = new Object[]{DatasetFactory.createRange((double)12.0)};
        objectArrayArray[8] = new Object[]{new TimeUnit()};
        arguments = objectArrayArray;
    }

    @Test
    public void testFinder() throws MetadataException {
        Class clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(IExtendedMetadata.class);
        Assert.assertEquals(IExtendedMetadata.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(DynamicConnectionInfo.class);
        Assert.assertEquals(DynamicConnectionInfo.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(OriginMetadataImpl.class);
        Assert.assertEquals(OriginMetadata.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(new DynamicConnectionInfo(){
            private static final long serialVersionUID = 3467617639382611191L;
        }.getClass());
        Assert.assertEquals(DynamicConnectionInfo.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(new InnerMetadata().getClass());
        Assert.assertEquals(InnerMetadata.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(new InnerMetadata2().getClass());
        Assert.assertEquals(InnerMetadata2.class, (Object)clazz);
    }

    @Test
    public void testFinderWithInproperMetadataType() {
        try {
            LazyDatasetBase.findMetadataTypeSubInterfaces(MetadataType.class);
            Assert.fail((String)"Should not be able to find direct implementation of MetadataType");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        MetadataType md = new MetadataType(){
            private static final long serialVersionUID = 1L;

            public MetadataType clone() {
                return null;
            }
        };
        try {
            LazyDatasetBase.findMetadataTypeSubInterfaces(md.getClass());
            Assert.fail((String)"Should not be able to find anonymous direct implementation of MetadataType");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        DoubleDataset d = DatasetFactory.zeros((int[])new int[]{2, 3});
        try {
            d.addMetadata(md);
            Assert.fail((String)"Should not be able to add anonymous direct implementation of MetadataType");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testCreator() throws MetadataException {
        ErrorMetadata emd = (ErrorMetadata)MetadataFactory.createMetadata(ErrorMetadata.class, (Object[])new Object[0]);
        Assert.assertEquals((Object)new ErrorMetadataImpl().getError(), (Object)emd.getError());
    }

    @Test
    public void testMetadata() throws MetadataException {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("Hello", "World");
        IMetadata imd = (IMetadata)MetadataFactory.createMetadata(IMetadata.class, (Object[])new Object[]{meta});
        Assert.assertEquals(meta.get("Hello"), (Object)imd.clone().getMetaValue("Hello"));
    }

    @Test
    public void testAllCreators() throws MetadataException, ClassNotFoundException, IOException {
        int n = types.length;
        int i = 0;
        while (i < n) {
            Class mc = types[i];
            Object[] params = arguments[i];
            MetadataType md = MetadataFactory.createMetadata((Class)mc, (Object[])params);
            Object exp = null;
            Object act = null;
            switch (i) {
                case 0: {
                    IMetadata m0 = (IMetadata)md;
                    exp = 0;
                    act = m0.getMetaNames().size();
                    break;
                }
                case 1: {
                    ErrorMetadata m1 = (ErrorMetadata)md;
                    exp = params[0];
                    act = m1.getError();
                    break;
                }
                case 2: {
                    AxesMetadata m2 = (AxesMetadata)md;
                    exp = params[0];
                    act = m2.getAxes().length;
                    break;
                }
                case 3: {
                    DimensionMetadata m3 = (DimensionMetadata)md;
                    exp = params[2];
                    act = m3.getDataChunkDimensions();
                    break;
                }
                case 4: {
                    MaskMetadata m4 = (MaskMetadata)md;
                    exp = ((Dataset)params[0]).getShape();
                    act = m4.getMask().getShape();
                    break;
                }
                case 5: {
                    OriginMetadata m5 = (OriginMetadata)md;
                    exp = params[3];
                    act = m5.getFilePath();
                    break;
                }
                case 6: {
                    PeemMetadata m6 = (PeemMetadata)md;
                    exp = params[1];
                    act = m6.getScaling();
                    break;
                }
                case 7: {
                    StatisticsMetadata m7 = (StatisticsMetadata)md;
                    exp = ((Dataset)params[0]).min(new boolean[]{true});
                    act = m7.getMinimum(new boolean[]{true});
                    break;
                }
                case 8: {
                    UnitMetadata m8 = (UnitMetadata)md;
                    exp = ((TimeUnit)params[0]).getName();
                    act = m8.getUnit().getName();
                }
            }
            Assert.assertTrue((boolean)Objects.deepEquals(exp, act));
            this.checkSerializable(md);
            ++i;
        }
    }

    private void checkSerializable(MetadataType md) throws IOException, ClassNotFoundException, MetadataException {
        DoubleDataset a = DatasetFactory.createRange((double)12.0);
        a.setShape(new int[]{3, 4});
        a.addMetadata(md);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream ostream = new ObjectOutputStream(out);
        ostream.writeObject(a);
        ostream.close();
        byte[] bytes = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream istream = new ObjectInputStream(in);
        Dataset b = (Dataset)Dataset.class.cast(istream.readObject());
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)b);
    }

    class InnerMetadata
    implements MetadataType {
        private static final long serialVersionUID = 93680612340323601L;

        public InnerMetadata clone() {
            return new InnerMetadata();
        }
    }

    static class InnerMetadata2
    implements MetadataType {
        private static final long serialVersionUID = 93680612340323601L;

        public InnerMetadata2 clone() {
            return new InnerMetadata2();
        }
    }

    static class TimeUnit
    implements Unit<Time>,
    Serializable {
        private static final long serialVersionUID = 4921003883507361264L;

        TimeUnit() {
        }

        public String getSymbol() {
            return "AE";
        }

        public String getName() {
            return "aeon";
        }

        public Dimension getDimension() {
            return null;
        }

        public Unit<Time> getSystemUnit() {
            return null;
        }

        public Map<? extends Unit<?>, Integer> getBaseUnits() {
            return null;
        }

        public boolean isCompatible(Unit<?> that) {
            return false;
        }

        public <T extends Quantity<T>> Unit<T> asType(Class<T> type) throws ClassCastException {
            return null;
        }

        public UnitConverter getConverterTo(Unit<Time> that) throws UnconvertibleException {
            return null;
        }

        public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
            return null;
        }

        public Unit<Time> alternate(String symbol) {
            return null;
        }

        public Unit<Time> shift(double offset) {
            return null;
        }

        public Unit<Time> multiply(double multiplier) {
            return null;
        }

        public Unit<?> multiply(Unit<?> multiplier) {
            return null;
        }

        public Unit<?> inverse() {
            return null;
        }

        public Unit<Time> divide(double divisor) {
            return null;
        }

        public Unit<?> divide(Unit<?> divisor) {
            return null;
        }

        public Unit<?> root(int n) {
            return null;
        }

        public Unit<?> pow(int n) {
            return null;
        }

        public Unit<Time> transform(UnitConverter operation) {
            return null;
        }
    }
}

