/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.SingleInputBroadcastIterator;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class SingleInputBroadcastIteratorTest {
    @Test
    public void testBroadcastWithNoOutput() {
        Dataset a = DatasetFactory.createRange((double)5.0, (int)6).reshape(new int[]{5, 1});
        Dataset b = DatasetFactory.createRange((double)2.0, (double)8.0, (double)1.0, (int)6);
        SingleInputBroadcastIterator it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{6}, (int[])it.getShape());
        Dataset c = DatasetFactory.zeros((int[])it.getShape(), (int)6);
        int j = 0;
        while (j < 6) {
            Assert.assertTrue((boolean)it.hasNext());
            c.set((Object)it.aDouble, j);
            Assert.assertEquals((double)b.getDouble(j), (double)it.aDouble, (double)1.0E-15);
            ++j;
        }
        a = DatasetFactory.createFromObject((Object)1);
        it = new SingleInputBroadcastIterator(a, null);
        it.setOutputDouble(true);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[0], (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape(), (int)6);
        Assert.assertTrue((boolean)it.hasNext());
        c.set((Object)it.aDouble);
        Assert.assertEquals((double)a.getDouble(), (double)it.aDouble, (double)1.0E-15);
        a = DatasetFactory.createRange((double)5.0, (int)6).reshape(new int[]{5, 1});
        b = DatasetFactory.createRange((double)2.0, (double)8.0, (double)1.0, (int)6).getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(2))});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape(), (int)6);
        j = 0;
        while (j < 3) {
            Assert.assertTrue((boolean)it.hasNext());
            c.set((Object)it.aDouble, j);
            Assert.assertEquals((double)b.getDouble(j), (double)it.aDouble, (double)1.0E-15);
            Assert.assertEquals((double)c.getDouble(j), (double)((double)(2 * j) + 2.0), (double)1.0E-15);
            ++j;
        }
    }

    @Test
    public void testBroadcastWithOutput() {
        int j;
        Dataset a = DatasetFactory.createRange((double)10.0, (int)6);
        Dataset c = DatasetFactory.zeros((int[])new int[]{10}, (int)6);
        SingleInputBroadcastIterator it = new SingleInputBroadcastIterator(a, c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10}, (int[])it.getShape());
        int i = 0;
        while (i < 10) {
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((double)a.getDouble(i), (double)it.aDouble, (double)1.0E-15);
            c.setObjectAbs(it.oIndex, (Object)it.aDouble);
            Assert.assertEquals((double)c.getDouble(i), (double)i, (double)1.0E-15);
            ++i;
        }
        c = a = DatasetFactory.createRange((double)120.0, (int)6).reshape(new int[]{10, 12});
        it = new SingleInputBroadcastIterator(a, c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)c.getDouble(i, j), (double)(i * 12 + j), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        c = a = DatasetFactory.createRange((double)240.0, (int)6).reshape(new int[]{20, 12}).getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(2))});
        it = new SingleInputBroadcastIterator(a, c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)c.getDouble(i, j), (double)(24 * i + j), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        a = DatasetFactory.createRange((double)12.0, (int)6);
        c = DatasetFactory.zeros((int[])new int[]{10, 12}, (int)6);
        it = new SingleInputBroadcastIterator(a, c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(j), (double)it.aDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)c.getDouble(i, j), (double)j, (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        c = DatasetFactory.zeros((int)3, (int[])new int[]{10, 12}, (int)6);
        it = new SingleInputBroadcastIterator(a, c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        CompoundDataset cc = (CompoundDataset)c;
        int isc = c.getElementsPerItem();
        double[] ca = new double[isc];
        int i2 = 0;
        while (i2 < 10) {
            int j2 = 0;
            while (j2 < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(j2), (double)it.aDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)c.getDouble(i2, j2), (double)j2, (double)1.0E-15);
                cc.getDoubleArray(ca, i2, j2);
                int k = 1;
                while (k < isc) {
                    Assert.assertEquals((double)ca[k], (double)ca[0], (double)1.0E-15);
                    ++k;
                }
                ++j2;
            }
            ++i2;
        }
    }
}

