/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.openliberty.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.FatJarDetector;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.build.AssemblyConfiguration;

public class OpenLibertyGenerator
extends JavaExecGenerator {
    protected static final String LIBERTY_SELF_EXTRACTOR = "wlp.lib.extract.SelfExtractRun";
    protected static final String LIBERTY_RUNNABLE_JAR = "LIBERTY_RUNNABLE_JAR";
    protected static final String JAVA_APP_JAR = "JAVA_APP_JAR";
    private String runnableJarName = null;

    public OpenLibertyGenerator(GeneratorContext context) {
        super(context, "openliberty");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"io.openliberty.tools", (String)"liberty-maven-plugin");
    }

    protected List<String> extractPorts() {
        ArrayList<String> ret = new ArrayList<String>();
        this.addPortIfValid(ret, this.getConfig((Configs.Key)JavaExecGenerator.Config.webPort, "9080"));
        this.addPortIfValid(ret, this.getConfig((Configs.Key)JavaExecGenerator.Config.jolokiaPort));
        this.addPortIfValid(ret, this.getConfig((Configs.Key)JavaExecGenerator.Config.prometheusPort));
        return ret;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        Map ret = super.getEnv(prePackagePhase);
        if (this.runnableJarName != null) {
            ret.put(LIBERTY_RUNNABLE_JAR, this.runnableJarName);
            ret.put(JAVA_APP_JAR, this.runnableJarName);
        }
        return ret;
    }

    protected AssemblyConfiguration createAssembly() {
        AssemblyConfiguration.AssemblyConfigurationBuilder builder = AssemblyConfiguration.builder();
        builder.targetDir(this.getConfig((Configs.Key)JavaExecGenerator.Config.targetDir));
        this.addAssembly(builder);
        return builder.build();
    }

    protected void addAssembly(AssemblyConfiguration.AssemblyConfigurationBuilder builder) {
        String assemblyRef = this.getConfig((Configs.Key)JavaExecGenerator.Config.assemblyRef);
        if (assemblyRef != null) {
            builder.descriptorRef(assemblyRef);
        } else {
            ArrayList<AssemblyFileSet> fileSets = new ArrayList<AssemblyFileSet>(this.addAdditionalFiles(this.getProject()));
            if (this.isFatJar()) {
                FatJarDetector.Result fatJar = this.detectFatJar();
                JavaProject project = this.getProject();
                if (fatJar != null) {
                    AssemblyFileSet fileSet = this.getOutputDirectoryFileSet(fatJar, project);
                    if (LIBERTY_SELF_EXTRACTOR.equals(fatJar.getMainClass())) {
                        this.runnableJarName = fatJar.getArchiveFile().getName();
                    }
                    fileSets.add(fileSet);
                }
            } else {
                builder.descriptorRef("artifact-with-dependencies");
            }
            builder.inline(Assembly.builder().fileSets(fileSets).build());
        }
    }

    public List<AssemblyFileSet> addAdditionalFiles(JavaProject project) {
        ArrayList<AssemblyFileSet> fileSets = new ArrayList<AssemblyFileSet>();
        fileSets.add(this.createFileSet(project, "src/main/jkube-includes/bin", "bin", "0755"));
        fileSets.add(this.createFileSet(project, "src/main/jkube-includes", ".", "0644"));
        fileSets.add(this.createFileSet(project, "src/main/liberty/config", "src/wlp/config", "0644"));
        return fileSets;
    }
}

