/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceNotFoundException;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;

public class NewViewpointProjectPage
extends WizardPage {
    private static final String SPACE = " ";
    private Text viewpointIdText;
    private Text viewpointNameText;
    private Text viewpointShortNameText;
    private Text projectNameText;
    private ISelection selection;

    public NewViewpointProjectPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Viewpoint creation wizard");
        this.setDescription("This wizard creates a project and a viewpoint model.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.createFirstLine(container);
        this.createSecondLine(container);
        this.createThirdLine(container);
        this.createFourthLine(container);
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void createThirdLine(Composite container) {
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText("&Viewpoint short name:");
        this.viewpointShortNameText = new Text(container, 2052);
        this.viewpointShortNameText.setLayoutData((Object)gd);
        this.viewpointShortNameText.setText("myviewpoint");
        this.viewpointShortNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewViewpointProjectPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
    }

    private void createFourthLine(Composite container) {
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText("&Viewpoint ID:");
        this.viewpointIdText = new Text(container, 2052);
        this.viewpointIdText.setLayoutData((Object)gd);
        this.viewpointIdText.setText("org.polarsys.kitalpha.viewpoint.myviewpoint");
        this.viewpointIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewViewpointProjectPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
    }

    private void createSecondLine(Composite container) {
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText("&Viewpoint name:");
        this.viewpointNameText = new Text(container, 2052);
        this.viewpointNameText.setLayoutData((Object)gd);
        this.viewpointNameText.setText("My Viewpoint");
        this.viewpointNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewViewpointProjectPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
    }

    private void createFirstLine(Composite container) {
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText("&Project name:");
        this.projectNameText = new Text(container, 2052);
        this.projectNameText.setLayoutData((Object)gd);
        this.projectNameText.setText("org.polarsys.kitalpha.viewpoint.myviewpointproject");
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewViewpointProjectPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
    }

    private void dialogChanged() {
        String projectName = this.getProjectName();
        String vpName = this.getViewpointName();
        String vpShortName = this.getViewpointShortName();
        String vpId = this.getViewpointId();
        if (projectName.length() == 0) {
            this.updateStatus("Project name must be specified");
            return;
        }
        if (vpShortName.length() == 0) {
            this.updateStatus("Viewpoint short name must be specified");
            return;
        }
        if (vpName.length() == 0) {
            this.updateStatus("Viewpoint name must be specified");
            return;
        }
        if (vpId.length() == 0) {
            this.updateStatus("Viewpoint Id must be specified");
            return;
        }
        if (vpId.contains(SPACE)) {
            this.updateStatus("Viewpoint Id must be valid");
            return;
        }
        if (vpShortName.contains(SPACE)) {
            this.updateStatus("Viewpoint short name must be valid");
            return;
        }
        if (projectName.contains(SPACE)) {
            this.updateStatus("Project name must be valid");
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            this.updateStatus("Project exists already");
            return;
        }
        try {
            ResourceReuse.createHelper().getResource(vpId);
            this.updateStatus("The id is already in use");
            return;
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.updateStatus(null);
            return;
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getProjectName() {
        return this.projectNameText.getText();
    }

    public String getViewpointName() {
        return this.viewpointNameText.getText();
    }

    public String getViewpointShortName() {
        return this.viewpointShortNameText.getText();
    }

    public String getViewpointId() {
        return this.viewpointIdText.getText();
    }
}

