/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree;

import java.util.Collection;
import java.util.HashSet;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.IViewpointTreeDescription;

public class ViewpointTreeDescription
implements IViewpointTreeDescription {
    private String viewpointName;
    private String viewpointId;
    private String eRootPathFragment;
    private boolean isToKeep;
    private Collection<IViewpointTreeDescription> children;
    private Collection<IViewpointTreeDescription> parents;
    private Collection<IViewpointTreeDescription> dependencies;
    private Collection<IViewpointTreeDescription> usedViewpoints;
    private Collection<String> nsUris;

    public ViewpointTreeDescription(String viewpointName, String viewpointId, String eRootPathFragment) {
        this.viewpointName = viewpointName;
        this.viewpointId = viewpointId;
        this.eRootPathFragment = eRootPathFragment;
        this.isToKeep = true;
        this.children = new HashSet<IViewpointTreeDescription>();
        this.parents = new HashSet<IViewpointTreeDescription>();
        this.dependencies = new HashSet<IViewpointTreeDescription>();
        this.usedViewpoints = new HashSet<IViewpointTreeDescription>();
        this.nsUris = new HashSet<String>();
    }

    @Override
    public String getViewpointName() {
        return this.viewpointName;
    }

    @Override
    public String getViewpointId() {
        return this.viewpointId;
    }

    @Override
    public Collection<IViewpointTreeDescription> getChildren() {
        return this.children;
    }

    @Override
    public Collection<IViewpointTreeDescription> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getRootEObject() {
        return this.eRootPathFragment;
    }

    @Override
    public void addChild(IViewpointTreeDescription child) {
        if (this != child) {
            this.getChildren().add(child);
        }
    }

    @Override
    public void addDependency(IViewpointTreeDescription dependency) {
        this.getDependencies().add(dependency);
    }

    @Override
    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public boolean hasDependencies() {
        return !this.getDependencies().isEmpty();
    }

    @Override
    public Collection<IViewpointTreeDescription> getParents() {
        return this.parents;
    }

    @Override
    public void addParent(IViewpointTreeDescription parent) {
        if (this != parent) {
            this.getParents().add(parent);
        }
    }

    @Override
    public boolean hasParents() {
        return !this.getParents().isEmpty();
    }

    @Override
    public boolean isCandidateToKeep() {
        return this.isToKeep;
    }

    @Override
    public void setAsCandidateToKeep(boolean toKeep) {
        this.isToKeep = toKeep;
    }

    @Override
    public Collection<String> getViewpointNsUri() {
        return this.nsUris;
    }

    @Override
    public void addViewpointNsUri(String nsuri) {
        if (!this.getViewpointNsUri().contains(nsuri)) {
            this.getViewpointNsUri().add(nsuri);
        }
    }

    @Override
    public void addAllViewpointNsUri(Collection<String> nsuri) {
        for (String uri : nsuri) {
            this.addViewpointNsUri(uri);
        }
    }

    @Override
    public Collection<IViewpointTreeDescription> getUsedViewpoints() {
        return this.usedViewpoints;
    }

    @Override
    public void addUsedViewpoint(IViewpointTreeDescription usedVpd) {
        if (!this.getUsedViewpoints().contains(usedVpd)) {
            this.getUsedViewpoints().add(usedVpd);
        }
    }

    public Collection<IViewpointTreeDescription> getAllParent() {
        HashSet<IViewpointTreeDescription> allParents = new HashSet<IViewpointTreeDescription>();
        for (IViewpointTreeDescription vpd : this.getParents()) {
            allParents.add(vpd);
            this.collectAllParent(vpd, allParents, this);
        }
        return allParents;
    }

    private void collectAllParent(IViewpointTreeDescription vpd, Collection<IViewpointTreeDescription> allParents, ViewpointTreeDescription checkedVpd) {
        if (vpd == null || allParents == null) {
            return;
        }
        for (IViewpointTreeDescription vpd_parent : vpd.getParents()) {
            if (vpd_parent == checkedVpd) continue;
            allParents.add(vpd_parent);
            this.collectAllParent(vpd_parent, allParents, checkedVpd);
        }
    }

    public Collection<IViewpointTreeDescription> getAllChildren() {
        HashSet<IViewpointTreeDescription> allChildren = new HashSet<IViewpointTreeDescription>();
        for (IViewpointTreeDescription vpd : this.getChildren()) {
            allChildren.add(vpd);
            this.collectAllChildren(vpd, allChildren, this);
        }
        return allChildren;
    }

    private void collectAllChildren(IViewpointTreeDescription vpd, Collection<IViewpointTreeDescription> allChildren, ViewpointTreeDescription checkedVpd) {
        if (vpd == null || allChildren == null) {
            return;
        }
        for (IViewpointTreeDescription vpd_child : vpd.getChildren()) {
            if (vpd_child == checkedVpd) continue;
            allChildren.add(vpd_child);
            this.collectAllChildren(vpd_child, allChildren, checkedVpd);
        }
    }

    @Override
    public void updateCandidates(boolean toKeep) {
        Collection<IViewpointTreeDescription> allChildren = this.getAllChildren();
        for (IViewpointTreeDescription child : allChildren) {
            child.setAsCandidateToKeep(toKeep);
        }
        Collection<IViewpointTreeDescription> allParents = this.getAllParent();
        if (toKeep && !allParents.isEmpty()) {
            for (IViewpointTreeDescription parent : allParents) {
                parent.setAsCandidateToKeep(toKeep);
            }
        }
    }
}

