/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.ui.Activator;
import org.polarsys.kitalpha.resourcereuse.ui.Messages;
import org.polarsys.kitalpha.resourcereuse.ui.dialog.ResourceSearchDialog;
import org.polarsys.kitalpha.resourcereuse.ui.drag.ModelReuseDragSourceListener;
import org.polarsys.kitalpha.resourcereuse.ui.views.SearchViewContentProvider;
import org.polarsys.kitalpha.resourcereuse.ui.views.SearchViewLabelProvider;

public class ResourceSearchView
extends ViewPart {
    public static final String ID = "org.polarsys.kitalpha.resourcereuse.ui.views.ResourceSearchView";
    private static final String ID_COLUMN = "id";
    private static final String NAME_COLUMN = "name";
    private static final String DOMAIN_COLUMN = "domain";
    private static final String VERSION_COLUMN = "version";
    private static final String TAGS_COLUMN = "tags";
    private static final String PATH_COLUMN = "path";
    private TableViewer viewer;
    private Action newSearchAction;
    private Action refreshSearchAction;
    private Action openResourceAction;
    private final SearchCriteria criteria = new SearchCriteria();

    public ResourceSearchView() {
        this.criteria.setId(".*");
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66308);
        final Table table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        SelectionListener headerListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn newSortColumn;
                TableColumn currentSortColumn = table.getSortColumn();
                if (currentSortColumn.equals(newSortColumn = (TableColumn)e.getSource())) {
                    int sortDirection = table.getSortDirection();
                    table.setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    table.setSortColumn(newSortColumn);
                    table.setSortDirection(1024);
                }
                ResourceSearchView.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        TableColumn idColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        idColumn.addSelectionListener(headerListener);
        idColumn.setText(Messages.id_Field_Label);
        idColumn.setResizable(true);
        idColumn.setData((Object)0);
        TableColumn nameColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 100, true));
        nameColumn.addSelectionListener(headerListener);
        nameColumn.setText(Messages.name_Field_Label);
        nameColumn.setResizable(true);
        nameColumn.setData((Object)1);
        TableColumn domainColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 80, true));
        domainColumn.addSelectionListener(headerListener);
        domainColumn.setText(Messages.domain_Field_Label);
        domainColumn.setResizable(true);
        domainColumn.setData((Object)2);
        TableColumn versionColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
        versionColumn.addSelectionListener(headerListener);
        versionColumn.setText(Messages.version_Field_Label);
        versionColumn.setResizable(true);
        versionColumn.setData((Object)3);
        TableColumn tagColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        tagColumn.addSelectionListener(headerListener);
        tagColumn.setText(Messages.tags_Field_Label);
        tagColumn.setResizable(true);
        tagColumn.setData((Object)4);
        TableColumn pathColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 300, true));
        pathColumn.addSelectionListener(headerListener);
        pathColumn.setText(Messages.path_Field_Label);
        pathColumn.setResizable(true);
        pathColumn.setData((Object)5);
        table.setSortColumn(nameColumn);
        table.setSortDirection(1024);
        this.viewer.setColumnProperties(new String[]{ID_COLUMN, NAME_COLUMN, DOMAIN_COLUMN, VERSION_COLUMN, TAGS_COLUMN, PATH_COLUMN});
        this.viewer.setContentProvider((IContentProvider)new SearchViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SearchViewLabelProvider());
        class ResourceTableSorter
        extends ViewerSorter {
            ResourceTableSorter() {
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                TableViewer viewer2 = ResourceSearchView.this.viewer;
                ITableLabelProvider lprov = (ITableLabelProvider)viewer2.getLabelProvider();
                Integer column = (Integer)viewer2.getTable().getSortColumn().getData();
                String name1 = lprov.getColumnText(e1, column == null ? 0 : column);
                String name2 = lprov.getColumnText(e2, column == null ? 0 : column);
                if (viewer2.getTable().getSortDirection() == 128) {
                    return this.getComparator().compare(name1, name2);
                }
                return this.getComparator().compare(name2, name1);
            }
        }
        this.viewer.setSorter((ViewerSorter)new ResourceTableSorter());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.addDragSupport();
    }

    private void addDragSupport() {
        int operations = 7;
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)new ModelReuseDragSourceListener(this.viewer));
    }

    private void updateView(Resource[] resources) {
        this.viewer.setInput((Object)resources);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourceSearchView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.newSearchAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshSearchAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.newSearchAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newSearchAction);
        manager.add((IAction)this.refreshSearchAction);
    }

    private void makeActions() {
        this.newSearchAction = new Action(){

            public void run() {
                ResourceSearchDialog dialog = new ResourceSearchDialog(ResourceSearchView.this.getViewSite().getShell(), ResourceSearchView.this.criteria);
                if (dialog.open() == 0) {
                    ResourceHelper helper = ResourceReuse.createHelper();
                    Resource[] resources = helper.getResources(ResourceSearchView.this.criteria);
                    ResourceSearchView.this.updateView(resources);
                }
            }
        };
        this.newSearchAction.setText(Messages.SearchView_newSearch_Action_label);
        this.newSearchAction.setToolTipText(Messages.SearchView_newSearch_Action_tooltip);
        this.newSearchAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("obj16/find.gif"));
        this.refreshSearchAction = new Action(){

            public void run() {
                ResourceHelper helper = ResourceReuse.createHelper();
                Resource[] resources = helper.getResources(ResourceSearchView.this.criteria);
                ResourceSearchView.this.updateView(resources);
            }
        };
        this.refreshSearchAction.setText(Messages.SearchView_refreshSearch_Action_label);
        this.refreshSearchAction.setToolTipText(Messages.SearchView_refreshSearch_Action_tooltip);
        this.refreshSearchAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("obj16/refresh.png"));
        this.openResourceAction = new Action(){

            public void run() {
                ISelection selection = ResourceSearchView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ResourceSearchView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResourceSearchView.this.openResourceAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Resource Search View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

