/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.polarsys.kitalpha.ad.af.coredomain.af.model.edit.provider.AfItemProviderAdapterFactory;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointPackage;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.edit.provider.ToolsItemProviderAdapterFactory;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelManager;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ResourceManager;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.WorkspaceManager;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.AFSelectionProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.DefaultSelectionProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ProjectSelectionListener;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.Tab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.TabFactory;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceNotFoundException;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ViewpointView
extends ViewPart
implements ISelectionProvider {
    private Viewpoint viewpoint;
    private Resource viewpointResource;
    private ModelManager modelManager;
    private final List<Tab> tabs = new ArrayList<Tab>();
    private ModelLoader loader;
    private ProjectSelectionListener projectListener;
    private AFSelectionProvider selectionProvider;
    private PropertySheetPage propertySheetPage;
    private String resourceId;
    private ViewpointManager.OverallListener viewpointListener;
    private FormToolkit toolkit;
    private CTabFolder folder;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.initResource();
            this.viewpointListener = new HiddingListener(site);
            ViewpointManager.addOverallListener((ViewpointManager.OverallListener)this.viewpointListener);
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
        this.selectionProvider = AFSelectionProvider.INSTANCE.getSelectionProvider("org.polarsys.capella.core.af.integration.provider.CapellaSelectionProvider");
        if (this.selectionProvider == null) {
            AD_Log.getDefault().logWarning("Cannot find selection provider: org.polarsys.capella.core.af.integration.provider.CapellaSelectionProvider");
            this.selectionProvider = AFSelectionProvider.INSTANCE.getSelectionProvider("org.polarsys.kitalpha.ad.integration.sirius.providers.SiriusSelectionProvider");
            if (this.selectionProvider == null) {
                AD_Log.getDefault().logError("Cannot find selection provider: org.polarsys.kitalpha.ad.integration.sirius.providers.SiriusSelectionProvider");
                this.selectionProvider = new DefaultSelectionProvider();
            }
        }
        this.loader.loadModel();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.loader, 39);
        TabFactory.INSTANCE.createTab(this.resourceId, this.tabs, site);
        this.initializeEditingDomain();
    }

    private void initResource() throws ResourceNotFoundException {
        this.viewpointResource = ResourceReuse.createHelper().getResource(this.resourceId);
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.toolkit = new FormToolkit(display);
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        this.folder = new CTabFolder(composite, 1088);
        this.folder.setUnselectedCloseVisible(false);
        this.folder.setSimple(false);
        this.init();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setFocus() {
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        this.resourceId = cfig.getAttribute("resourceId");
        this.loader = new ModelLoader();
    }

    public void dispose() {
        for (Tab tab : this.tabs) {
            tab.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.loader);
        this.loader.disposeModel();
        if (this.selectionProvider != null) {
            this.selectionProvider.removeListener(this.projectListener);
            this.selectionProvider.dispose();
        }
        if (this.viewpointListener != null) {
            ViewpointManager.removeOverallListener((ViewpointManager.OverallListener)this.viewpointListener);
        }
        this.viewpointListener = null;
        this.viewpointResource = null;
        super.dispose();
    }

    private void init() {
        this.updatePartName();
        boolean designMode = this.isDesignMode();
        int selectionIndex = this.folder.getSelectionIndex();
        for (Tab tab : this.tabs) {
            tab.dispose();
            if (tab.isDesignOnly() && !this.isDesignMode()) continue;
            tab.createTab(this.toolkit, this.folder);
        }
        this.folder.setLayoutData((Object)new GridData(1808));
        this.folder.setSelection(selectionIndex == -1 ? 0 : selectionIndex);
        for (Tab tab : this.tabs) {
            if (tab.isDesignOnly() && !designMode) continue;
            tab.setModelManager(this.viewpoint, this.modelManager);
            tab.setSelectionProvider(this.selectionProvider);
            tab.init();
        }
    }

    public void updatePartName() {
        String name = this.viewpoint.getName();
        boolean designMode = this.isDesignMode();
        if (designMode) {
            name = String.valueOf(name) + " [design]";
        }
        this.setPartName(name);
    }

    private boolean isDesignMode() {
        return !this.modelManager.getResourceManager().equals(WorkspaceManager.INSTANCE);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.propertySheetPage;
        }
        return super.getAdapter(key);
    }

    protected void initializeEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new AfItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ToolsItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(event -> {
            if (this.propertySheetPage != null && !this.propertySheetPage.getControl().isDisposed()) {
                this.propertySheetPage.refresh();
            }
        });
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        this.propertySheetPage = new ExtendedPropertySheetPage(editingDomain);
        this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
    }

    public ISelection getSelection() {
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        for (Tab tab : this.tabs) {
            ISelectionProvider prov = tab.getSelectionProvider();
            if (prov == null) continue;
            prov.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        for (Tab tab : this.tabs) {
            ISelectionProvider prov = tab.getSelectionProvider();
            if (prov == null) continue;
            prov.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        for (Tab tab : this.tabs) {
            ISelectionProvider prov = tab.getSelectionProvider();
            if (prov == null) continue;
            prov.setSelection(selection);
        }
    }

    private final class HiddingListener
    implements ViewpointManager.OverallListener {
        private final IViewSite site;

        private HiddingListener(IViewSite site) {
            this.site = site;
        }

        public void hasBeenDeactivated(Object ctx, Resource vp) {
            if (ViewpointView.this.resourceId != null && ViewpointView.this.resourceId.equals(vp.getId())) {
                ViewpointView.this.getSite().getShell().getDisplay().asyncExec(() -> this.site.getPage().hideView((IViewPart)ViewpointView.this));
            }
        }

        public void hasBeenActivated(Object ctx, Resource vp) {
        }

        public void hasBeenFiltered(Object ctx, Resource vp) {
        }

        public void hasBeenDisplayed(Object ctx, Resource vp) {
        }
    }

    private class ModelLoader
    implements IResourceChangeListener {
        private URI currentURI;

        private ModelLoader() {
        }

        public void reloadModel(final long timeStamp) {
            Job job = new Job("Update view"){

                protected IStatus run(IProgressMonitor monitor) {
                    long modelTimeStamp = ((ModelLoader)ModelLoader.this).ViewpointView.this.modelManager.getResourceManager().getModelTimeStamp();
                    if (timeStamp == modelTimeStamp) {
                        return Status.OK_STATUS;
                    }
                    ModelLoader.this.disposeModel();
                    try {
                        ViewpointView.this.initResource();
                    }
                    catch (ResourceNotFoundException e) {
                        AD_Log.getDefault().logError((Throwable)e);
                    }
                    ModelLoader.this.loadModel();
                    ViewpointView.this.getSite().getShell().getDisplay().asyncExec(() -> ViewpointView.this.init());
                    return Status.OK_STATUS;
                }
            };
            job.schedule(400L);
        }

        private boolean isLocalViewpoint() {
            return ViewpointView.this.viewpointResource.getProviderLocation().equals((Object)Location.WORSPACE);
        }

        public void loadModel() {
            URI uri = URIHelper.createURI((Resource)ViewpointView.this.viewpointResource);
            if (this.currentURI == null || !this.currentURI.equals(uri)) {
                this.disposeModel();
                ViewpointView.this.viewpoint = (Viewpoint)ResourceManager.getResourceSet().getEObject(uri, true);
                if (ViewpointView.this.viewpoint == null) {
                    throw new IllegalStateException("Viewpoint has not been loaded: " + uri.toString());
                }
                ViewpointView.this.viewpoint.eAdapters().add((Object)new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        int eventType = msg.getEventType();
                        Object feature = msg.getFeature();
                        if (eventType == 1 && ViewpointPackage.eINSTANCE.getNameElement_Name().equals(feature)) {
                            ViewpointView.this.updatePartName();
                        }
                    }
                });
                if (this.isLocalViewpoint()) {
                    ViewpointView.this.modelManager = ModelManager.createViewpointManager((Viewpoint)ViewpointView.this.viewpoint);
                } else {
                    ViewpointView.this.modelManager = ModelManager.createWorkspaceManager((Viewpoint)ViewpointView.this.viewpoint);
                    ViewpointView.this.projectListener = new ProjectSelectionListener();
                    ViewpointView.this.selectionProvider.addListener(ViewpointView.this.projectListener);
                }
                this.currentURI = uri;
            }
        }

        public void disposeModel() {
            if (ViewpointView.this.viewpoint != null) {
                org.eclipse.emf.ecore.resource.Resource eResource = ViewpointView.this.viewpoint.eResource();
                eResource.unload();
                ResourceManager.getResourceSet().getResources().remove((Object)eResource);
                ViewpointView.this.viewpoint = null;
            }
            if (ViewpointView.this.modelManager != null) {
                if (ViewpointView.this.projectListener != null) {
                    ViewpointView.this.getSite().getPage().removeSelectionListener((ISelectionListener)ViewpointView.this.projectListener);
                    ViewpointView.this.projectListener = null;
                }
                for (Tab tab : ViewpointView.this.tabs) {
                    tab.setModelManager(ViewpointView.this.viewpoint, null);
                }
                ViewpointView.this.modelManager.dispose();
                ViewpointView.this.modelManager = null;
            }
            this.currentURI = null;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.currentURI != null) {
                boolean deleted;
                boolean changed;
                boolean open;
                String project = this.currentURI.segment(1);
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                String path = ViewpointView.this.viewpointResource.getPath().substring(0, ViewpointView.this.viewpointResource.getPath().indexOf(35));
                IResourceDelta modelDelta = delta.findMember((IPath)new Path(path));
                IResourceDelta projectDelta = delta.findMember((IPath)new Path(project));
                boolean bl = projectDelta == null ? false : (open = (projectDelta.getFlags() & 0x4000) != 0);
                boolean bl2 = modelDelta == null ? false : (changed = (modelDelta.getKind() & 4) != 0);
                boolean bl3 = modelDelta == null ? false : (deleted = (modelDelta.getKind() & 2) != 0);
                if (open || changed || deleted) {
                    this.reloadModel(open ? 0L : modelDelta.getResource().getLocalTimeStamp());
                }
            }
        }
    }
}

