/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.desc.CoreModelHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Configuration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.ConfigurationElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.GData;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Generation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.GenerationConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Release;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.TargetApplication;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.ViewConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;

public class VpDslConfigurationHelper {
    public static final String VIEWPOINT_VERSION_DEFAULT = "0.0.0";
    public static final String VIEWPOINT_EE_DEFAULT = "JavaSE-1.6";
    public static final String VIEWPOINT_VISIBLITY_TAG = "stateHidden";
    public static final String VIEWPOINT_ACTIVABLE_TAG = "stateMutableActivation";
    private static final boolean DEFAULT_VIEWPOINT_VISIBILITY = true;
    private static final boolean DEFAULT_VIEWPOINT_ACTIVABLE_STATE = false;

    public static boolean isActivableViewpoint(Object object) {
        Configuration viewpointConfiguration = VpDslConfigurationHelper.getViewpointConfiguration(object);
        if (viewpointConfiguration != null) {
            ViewConfiguration vpViewConfig = VpDslConfigurationHelper.getViewpointConfigurationElement(object, ViewConfiguration.class);
            return vpViewConfig != null ? vpViewConfig.isActivable() : false;
        }
        return false;
    }

    public static boolean getViewpointVisibility(Object object) {
        Configuration viewpointConfiguration = VpDslConfigurationHelper.getViewpointConfiguration(object);
        if (viewpointConfiguration != null) {
            ViewConfiguration vpViewConfig = VpDslConfigurationHelper.getViewpointConfigurationElement(object, ViewConfiguration.class);
            return vpViewConfig != null ? vpViewConfig.isVisible() : true;
        }
        return true;
    }

    public static Configuration getViewpointConfiguration(Object object) {
        Viewpoint viewpoint = object instanceof Viewpoint ? (Viewpoint)object : CoreModelHelper.getDSLViewpoint(object);
        if (viewpoint != null) {
            for (Aspect aspect : viewpoint.getVP_Aspects()) {
                if (!(aspect instanceof Configuration)) continue;
                return (Configuration)aspect;
            }
        }
        return null;
    }

    public static String getViewpointVersion(Object object) {
        Release release = VpDslConfigurationHelper.getViewpointConfigurationElement(object, Release.class);
        return release != null ? release.getViewpointVersion().toString() : VIEWPOINT_VERSION_DEFAULT;
    }

    public static String getViewpointDescription(Object object) {
        Release release = VpDslConfigurationHelper.getViewpointConfigurationElement(object, Release.class);
        return release != null ? release.getViewpointDescription() : "";
    }

    public static EList<String> getViewpointRequiredExecutionEnvironmentList(Object object) {
        Release release = VpDslConfigurationHelper.getViewpointConfigurationElement(object, Release.class);
        return release != null ? release.getRequiredExecutionEnvironment() : new BasicEList<String>(){
            {
                this.add(VpDslConfigurationHelper.VIEWPOINT_EE_DEFAULT);
            }
        };
    }

    public static String getViewpointRequiredExecutionEnvironment(Object object) {
        EList requiredEE;
        Release release = VpDslConfigurationHelper.getViewpointConfigurationElement(object, Release.class);
        String result = null;
        if (release != null && !(requiredEE = release.getRequiredExecutionEnvironment()).isEmpty()) {
            for (String iEE : requiredEE) {
                result = result == null ? iEE : String.valueOf(result) + ", " + iEE;
            }
        }
        return result != null ? result : VIEWPOINT_EE_DEFAULT;
    }

    public static String getTargetApplication(Object object) {
        TargetApplication ta = VpDslConfigurationHelper.getViewpointConfigurationElement(object, TargetApplication.class);
        return ta != null ? ta.getType() : null;
    }

    public static String getRootProjectName(Object object) {
        GenerationConfiguration configuration = VpDslConfigurationHelper.getViewpointConfigurationElement(object, GenerationConfiguration.class);
        return configuration != null ? configuration.getProjectName() : null;
    }

    public static String getNsURI(Object object) {
        GenerationConfiguration configuration = VpDslConfigurationHelper.getViewpointConfigurationElement(object, GenerationConfiguration.class);
        return configuration != null ? configuration.getNsuri() : null;
    }

    public static boolean getGenerateModel(Object object) {
        GData dataGenerationConf = VpDslConfigurationHelper.getGDataElement(object);
        return dataGenerationConf != null ? dataGenerationConf.isModel() : true;
    }

    public static boolean getGenerateEdit(Object object) {
        GData dataGenerationConf = VpDslConfigurationHelper.getGDataElement(object);
        return dataGenerationConf != null ? dataGenerationConf.isEdit() : true;
    }

    public static boolean getGenerateEditor(Object object) {
        GData dataGenerationConf = VpDslConfigurationHelper.getGDataElement(object);
        return dataGenerationConf != null ? dataGenerationConf.isEditor() : false;
    }

    public static boolean getGenerateTest(Object object) {
        GData dataGenerationConf = VpDslConfigurationHelper.getGDataElement(object);
        return dataGenerationConf != null ? dataGenerationConf.isTest() : false;
    }

    public static boolean getGenerateJavaDoc(Object object) {
        GData dataGenerationConf = VpDslConfigurationHelper.getGDataElement(object);
        return dataGenerationConf != null ? dataGenerationConf.isJavaDoc() : false;
    }

    public static boolean getOverwriteEcore(Object object) {
        GData dataGenerationConf = VpDslConfigurationHelper.getGDataElement(object);
        return dataGenerationConf != null ? dataGenerationConf.isOverwriteEcore() : true;
    }

    private static GData getGDataElement(Object object) {
        Generation generation = VpDslConfigurationHelper.getViewpointConfigurationElement(object, Generation.class);
        if (generation != null) {
            return generation.getOwnedDataGenerationConf();
        }
        return null;
    }

    private static <R extends ConfigurationElement> R getViewpointConfigurationElement(Object object, Class<R> clazz) {
        Configuration configuration = VpDslConfigurationHelper.getViewpointConfiguration(object);
        if (configuration != null) {
            for (ConfigurationElement configurationElement : configuration.getVpConfigurationElements()) {
                if (!clazz.isInstance(configurationElement)) continue;
                return (R)((ConfigurationElement)clazz.cast(configurationElement));
            }
        }
        return null;
    }
}

