/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.MissingExtensionException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class InvocationHelper {
    private static EditingDomain editingDomain;

    public static boolean validateAndInvoke(Activity activity, IProgressMonitor monitor) {
        try {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)activity);
            if (diagnostic.getSeverity() != 4) {
                InvocationHelper.invoke(activity, monitor);
                return true;
            }
        }
        catch (MissingExtensionException e) {
            e.printStackTrace();
        }
        catch (InvocationException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void invoke(Activity activity, IProgressMonitor monitor) throws MissingExtensionException, InvocationException, CoreException {
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
        IActivityManager activityManager = producer.createActivityManager(activity);
        activityManager.initializeContext();
        try {
            activityManager.invoke(monitor);
            activityManager.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Activity getActivity(URI activityURI) {
        EditingDomain editingDomain = InvocationHelper.getEditingDomain();
        ResourceSet rs = editingDomain.getResourceSet();
        return (Activity)rs.getEObject(activityURI, true);
    }

    private static EditingDomain getEditingDomain() {
        if (editingDomain == null) {
            InvocationHelper.initializeEditingDomain();
        }
        return editingDomain;
    }

    private static void initializeEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack statck = new BasicCommandStack();
        TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
        editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)statck, (ResourceSet)resourceSet);
    }
}

