/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.generation.desc.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.af.coredomain.af.model.AF;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.ArchitectureFramework;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.Viewpoints;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.AbstractGenerationEvent;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.listener.GenerationAdapter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.type.ViewpointGenerationEndEvent;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.PDEUtility;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.viewpoint.PlatformViewpointHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.viewpoint.ViewpointGenerationHelper;

class VpGenerationListenerForOrchestration
extends GenerationAdapter {
    private Stack<Viewpoint> _viewpointToGenerate = null;
    private List<Viewpoint> _viewpointToLink = null;
    private ArchitectureFramework _afSpecification = null;
    private String _afModelStringURI = null;
    private boolean _listenerIsActive = false;
    protected static final ViewpointGenerationHelper _generationHelper = new ViewpointGenerationHelper();
    private IProgressMonitor _monitor = new NullProgressMonitor();

    public VpGenerationListenerForOrchestration(Stack<Viewpoint> viewpointToGenerate, ArchitectureFramework afSpecification, String afModelStringURI, IProgressMonitor monitor) {
        this._viewpointToGenerate = viewpointToGenerate;
        this._viewpointToLink = new ArrayList<Viewpoint>();
        this._viewpointToLink.addAll(viewpointToGenerate);
        this._afSpecification = afSpecification;
        this._afModelStringURI = afModelStringURI;
        this._monitor = monitor;
        this._listenerIsActive = true;
        Viewpoint vp = viewpointToGenerate.pop();
        _generationHelper.generateViewpoint(vp, monitor);
    }

    public void addViewpointToLink(Viewpoint viewpoint) {
        if (!this._viewpointToLink.contains(viewpoint)) {
            this._viewpointToLink.add(viewpoint);
        }
    }

    public void generationEnd(AbstractGenerationEvent event) {
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (event instanceof ViewpointGenerationEndEvent) {
            if (this._listenerIsActive && this._viewpointToGenerate != null && !this._viewpointToGenerate.isEmpty()) {
                this.generateViewpoint();
            } else if (this._listenerIsActive) {
                this.updateAFRequiredBundles();
                this.patchAFModel();
            }
        }
    }

    private void generateViewpoint() {
        Viewpoint viewpoint = this._viewpointToGenerate.pop();
        _generationHelper.generateViewpoint(viewpoint, this._monitor);
    }

    private void updateAFRequiredBundles() {
        ArrayList<String> reuiredBundlesToAdd = new ArrayList<String>();
        Viewpoints vps = this._afSpecification.getAf_viewpoints();
        if (vps != null) {
            for (Viewpoint viewpoint : vps.getOwned_viewpoints()) {
                String bundleID = EcoreUtil.getURI((EObject)this.getAFViewpoint(viewpoint)).segment(1);
                reuiredBundlesToAdd.add(bundleID);
            }
        }
        String[] segments = this._afModelStringURI.split("/");
        String afBundleID = segments[1];
        IProject afProject = ResourcesPlugin.getWorkspace().getRoot().getProject(afBundleID);
        PDEUtility.updateRequiredBundles((IProject)afProject, reuiredBundlesToAdd, (IProgressMonitor)this._monitor);
    }

    private void patchAFModel() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)this._afModelStringURI, (boolean)false);
        Resource resource = resourceSet.getResource(uri, true);
        if (!resource.isLoaded()) {
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        EList content = resource.getContents();
        AF af = null;
        if (content != null && content.size() > 0) {
            af = (AF)content.get(0);
        }
        if (af != null) {
            for (Viewpoint viewpoint : this._viewpointToLink) {
                org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint afviewpoint = this.getAFViewpoint(viewpoint);
                af.getViewpoints().add((Object)afviewpoint);
            }
        }
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint getAFViewpoint(Viewpoint viewpoint) {
        String viewpointID = VpDslConfigurationHelper.getRootProjectName((Object)viewpoint);
        return PlatformViewpointHelper.getAFViewpoint((String)viewpointID, null);
    }
}

