/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation.command;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.ViewpointSelector;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.business.api.query.DEdgeQuery;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusRepresentation;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Representation;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RepresentationElement;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation.Activator;
import org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation.command.IllegaleResourceReuseResult;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceNotFoundException;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class SiriusViewpointRepresentationHandler {
    private final Session session;
    private final IProgressMonitor monitor;
    private final ViewpointSelector viewpointSelector;
    private final Collection<String> viewpointsToRemove;
    private final ResourceSet resourceSet;
    private final ResourceHelper resourceReuseHelper = ResourceReuse.createHelper();
    private final CompoundCommand cleanCommand;
    private Collection<org.eclipse.sirius.viewpoint.description.Viewpoint> usedSiriusViewpoints = null;

    public SiriusViewpointRepresentationHandler(Session session, Collection<String> viewpointToRemove, IProgressMonitor monitor) {
        assert (session != null);
        this.session = session;
        this.viewpointSelector = new ViewpointSelector(session);
        this.viewpointsToRemove = viewpointToRemove;
        this.monitor = monitor;
        this.resourceSet = new ResourceSetImpl();
        this.cleanCommand = new CompoundCommand("Cleaning Session form Viewpoint Data...");
    }

    public void clean() {
        this.init();
        if (this.cleanCommand.canExecute()) {
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)this.cleanCommand);
        }
        this.dispose();
    }

    private void init() {
        this.handleRepresentations();
        this.unselectSiriusViewpoints();
        this.deleteDViews();
    }

    private void deleteDViews() {
        if (this.usedSiriusViewpoints == null) {
            return;
        }
        Collection ownedViews = this.session.getOwnedViews();
        for (org.eclipse.sirius.viewpoint.description.Viewpoint viewpoint : this.usedSiriusViewpoints) {
            for (final DView dView : ownedViews) {
                if (!this.haveSameSiriusURI(dView.getViewpoint(), viewpoint)) continue;
                RecordingCommand removeDView = new RecordingCommand(this.session.getTransactionalEditingDomain(), "Remove DViews"){

                    protected void doExecute() {
                        Command removeCommand = RemoveCommand.create((EditingDomain)SiriusViewpointRepresentationHandler.this.session.getTransactionalEditingDomain(), (Object)dView);
                        if (removeCommand.canExecute()) {
                            SiriusViewpointRepresentationHandler.this.session.getTransactionalEditingDomain().getCommandStack().execute(removeCommand);
                        }
                    }
                };
                this.cleanCommand.append((Command)removeDView);
            }
        }
    }

    private void unselectSiriusViewpoints() {
        RecordingCommand unselectCommand = new RecordingCommand(this.session.getTransactionalEditingDomain(), "Unselect Viewpoints"){

            protected void doExecute() {
                for (org.eclipse.sirius.viewpoint.description.Viewpoint viewpoint : SiriusViewpointRepresentationHandler.this.getAllSiriusViewpointsFromADViewpoints()) {
                    SiriusViewpointRepresentationHandler.this.viewpointSelector.deselectViewpoint(viewpoint, SiriusViewpointRepresentationHandler.this.monitor);
                }
            }
        };
        this.cleanCommand.append((Command)unselectCommand);
    }

    private void handleRepresentations() {
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(this.session);
        for (DRepresentation rep : allRepresentations) {
            if (!(rep instanceof DDiagram) || this.deleteDiagram((DDiagram)rep)) continue;
            this.deactivateAdditionalLayers((DDiagram)rep);
            this.deactivateDiagramFilters((DDiagram)rep);
            this.deleteEdges((DDiagram)rep);
        }
    }

    private boolean deleteDiagram(DDiagram diagram) {
        boolean result = false;
        RepresentationDescription diagramDescription = DialectManager.INSTANCE.getDescription((DRepresentation)diagram);
        org.eclipse.sirius.viewpoint.description.Viewpoint vp = this.getContainingSiriusViewpoint((EObject)diagramDescription);
        if (this.isInViewpoints(this.getAllSiriusViewpointsFromADViewpoints(), vp)) {
            Collection allRepresentationDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(this.session);
            for (DRepresentationDescriptor repDesc : allRepresentationDescriptors) {
                if (!repDesc.getDescription().equals(diagramDescription)) continue;
                this.deleteRepresentations(repDesc);
                result = true;
            }
        }
        return result;
    }

    private void deactivateAdditionalLayers(DDiagram diagram) {
        EList layers = diagram.getActivatedLayers();
        for (Layer layer : layers) {
            org.eclipse.sirius.viewpoint.description.Viewpoint vp = this.getContainingSiriusViewpoint((EObject)layer);
            if (!this.isInViewpoints(this.getAllSiriusViewpointsFromADViewpoints(), vp) || !(layer instanceof AdditionalLayer)) continue;
            if (!((AdditionalLayer)layer).isActiveByDefault()) {
                ChangeLayerActivationCommand changeLayerCommand = new ChangeLayerActivationCommand(this.session.getTransactionalEditingDomain(), diagram, layer, this.monitor);
                this.cleanCommand.append((Command)changeLayerCommand);
                continue;
            }
            this.deleteRepresentations(diagram);
        }
    }

    private void deactivateDiagramFilters(final DDiagram diagram) {
        EList activatedFilters = diagram.getActivatedFilters();
        for (final FilterDescription filter : activatedFilters) {
            org.eclipse.sirius.viewpoint.description.Viewpoint viewpoint = this.getContainingSiriusViewpoint((EObject)filter);
            if (!this.isInViewpoints(this.getAllSiriusViewpointsFromADViewpoints(), viewpoint)) continue;
            RecordingCommand removeFilter = new RecordingCommand(this.session.getTransactionalEditingDomain(), "Deactivate Filters"){

                protected void doExecute() {
                    diagram.getActivatedFilters().remove((Object)filter);
                    ConcernService.resetCurrentConcern((DDiagram)diagram);
                }
            };
            this.cleanCommand.append((Command)removeFilter);
        }
    }

    private void deleteRepresentations(final DRepresentationDescriptor descriptor) {
        RecordingCommand deleteRep = new RecordingCommand(this.session.getTransactionalEditingDomain(), "Delete Representation"){

            protected void doExecute() {
                DialectManager.INSTANCE.deleteRepresentation(descriptor, SiriusViewpointRepresentationHandler.this.session);
            }
        };
        this.cleanCommand.append((Command)deleteRep);
    }

    private void deleteRepresentations(DDiagram diagram) {
        final Collection descriptors = DialectManager.INSTANCE.getRepresentationDescriptors((EObject)diagram, this.session);
        RecordingCommand deleteRep = new RecordingCommand(this.session.getTransactionalEditingDomain(), "Delete Representations"){

            protected void doExecute() {
                for (DRepresentationDescriptor descriptor : descriptors) {
                    DialectManager.INSTANCE.deleteRepresentation(descriptor, SiriusViewpointRepresentationHandler.this.session);
                }
            }
        };
        this.cleanCommand.append((Command)deleteRep);
    }

    private void deleteEdges(DDiagram diagram) {
        EList edges = diagram.getEdges();
        for (final DEdge dEdge : edges) {
            DEdgeQuery edgeQuery = new DEdgeQuery(dEdge);
            Option mapping = edgeQuery.getMapping();
            if (!mapping.some()) continue;
            org.eclipse.sirius.viewpoint.description.Viewpoint vp = this.getContainingSiriusViewpoint((EObject)mapping.get());
            if (!this.isInViewpoints(this.getAllSiriusViewpointsFromADViewpoints(), vp)) continue;
            RecordingCommand deleteEdges = new RecordingCommand(this.session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    Command c = RemoveCommand.create((EditingDomain)SiriusViewpointRepresentationHandler.this.session.getTransactionalEditingDomain(), (Object)dEdge);
                    if (c.canExecute()) {
                        SiriusViewpointRepresentationHandler.this.session.getTransactionalEditingDomain().getCommandStack().execute(c);
                    }
                }
            };
            this.cleanCommand.append((Command)deleteEdges);
        }
    }

    private Collection<org.eclipse.sirius.viewpoint.description.Viewpoint> getAllSiriusViewpointsFromADViewpoints() {
        if (this.usedSiriusViewpoints != null) {
            return this.usedSiriusViewpoints;
        }
        this.usedSiriusViewpoints = new HashSet<org.eclipse.sirius.viewpoint.description.Viewpoint>();
        Collection<Viewpoint> vps = this.getArchitectureDescriptionViewpoints();
        for (Viewpoint viewpoint : vps) {
            this.usedSiriusViewpoints.addAll(this.getSiriusViewpointsFromADViewpoint(viewpoint));
        }
        return this.usedSiriusViewpoints;
    }

    private Collection<org.eclipse.sirius.viewpoint.description.Viewpoint> getSiriusViewpointsFromADViewpoint(Viewpoint viewpoint) {
        HashSet<org.eclipse.sirius.viewpoint.description.Viewpoint> result = new HashSet<org.eclipse.sirius.viewpoint.description.Viewpoint>();
        Representation representation = viewpoint.getRepresentation();
        EList representations = representation.getRepresentations();
        for (RepresentationElement representationElement : representations) {
            if (!(representationElement instanceof SiriusRepresentation)) continue;
            Group odesign = ((SiriusRepresentation)representationElement).getOdesign();
            result.addAll((Collection<org.eclipse.sirius.viewpoint.description.Viewpoint>)odesign.getOwnedViewpoints());
        }
        return result;
    }

    private Collection<Viewpoint> getArchitectureDescriptionViewpoints() {
        HashSet<Viewpoint> result = new HashSet<Viewpoint>();
        for (String id : this.viewpointsToRemove) {
            try {
                Viewpoint vp = this.getArchitectureFrameworkViewpoint(id);
                result.add(vp);
            }
            catch (IllegaleResourceReuseResult | ResourceNotFoundException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation", e.getMessage(), e));
            }
        }
        return result;
    }

    private org.eclipse.sirius.viewpoint.description.Viewpoint getContainingSiriusViewpoint(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject.equals(EcoreUtil.getRootContainer((EObject)eObject))) {
            return null;
        }
        if (eObject instanceof org.eclipse.sirius.viewpoint.description.Viewpoint) {
            return (org.eclipse.sirius.viewpoint.description.Viewpoint)eObject;
        }
        return this.getContainingSiriusViewpoint(eObject.eContainer());
    }

    private boolean isInViewpoints(Collection<org.eclipse.sirius.viewpoint.description.Viewpoint> viewpoints, org.eclipse.sirius.viewpoint.description.Viewpoint subject) {
        if (subject != null) {
            for (org.eclipse.sirius.viewpoint.description.Viewpoint viewpoint : viewpoints) {
                if (!this.haveSameSiriusURI(viewpoint, subject)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean haveSameSiriusURI(org.eclipse.sirius.viewpoint.description.Viewpoint vp1, org.eclipse.sirius.viewpoint.description.Viewpoint vp2) {
        ViewpointQuery viewpointQuery = new ViewpointQuery(vp1);
        return viewpointQuery.hasSameSiriusURI(vp2);
    }

    private Viewpoint getArchitectureFrameworkViewpoint(String id) throws ResourceNotFoundException, IllegaleResourceReuseResult {
        Resource resource = this.resourceReuseHelper.getResource(id);
        String path = resource.getPath();
        URI uri = this.createPlatformPluginURI(path, true);
        EObject viewpoint = this.resourceSet.getEObject(uri, true);
        if (viewpoint instanceof Viewpoint) {
            return (Viewpoint)viewpoint;
        }
        throw new IllegaleResourceReuseResult("Resource referenced by " + id + " is not architecture Description Viewpoint");
    }

    private void dispose() {
        EList resources = this.resourceSet.getResources();
        for (org.eclipse.emf.ecore.resource.Resource resource : resources) {
            if (!resource.isLoaded()) continue;
            resource.unload();
        }
        this.cleanCommand.dispose();
        if (this.usedSiriusViewpoints != null) {
            this.usedSiriusViewpoints.clear();
        }
    }

    private URI createPlatformPluginURI(String path, boolean encode) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Could not create URI with null or empty path");
        }
        return URI.createURI((String)("platform:/plugin" + path));
    }
}

