/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension;

import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.polarsys.kitalpha.emde.extension.ExtensibleModel;
import org.polarsys.kitalpha.emde.extension.Model;
import org.polarsys.kitalpha.emde.extension.registry.URIFactory;

public class ExtendedModel
extends Model<ExtendedModel> {
    private final ExtensibleModel parent;
    private final String path;
    private final String qualifiedName;

    public ExtendedModel(ExtensibleModel parent, String name, URIFactory uriFactory) {
        super(name, uriFactory);
        Assert.isNotNull((Object)parent);
        this.parent = parent;
        this.parent.addExtendedModel(this);
        this.path = String.valueOf(this.getParent().getPath()) + "<-|-|->" + this.getName();
        this.qualifiedName = String.valueOf(this.getParent().getQualifiedName()) + "<-|-|->" + this.getName();
    }

    @Override
    public final String getPath() {
        return this.path;
    }

    public boolean equals(Object other_p) {
        return other_p instanceof ExtendedModel && ((ExtendedModel)other_p).getPath().equals(this.getPath());
    }

    public int hashCode() {
        return Objects.hashCode(this.getPath());
    }

    public ExtensibleModel getParent() {
        return this.parent;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ExtendedModel[extend=");
        result.append(this.getParent().getName());
        result.append(", name=");
        result.append(this.getName());
        result.append(", adapterFactory=");
        result.append(this.getURIFactory().getAdapterFactoryName());
        result.append(']');
        return result.toString();
    }
}

