/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.DataDerivTypeFunction;
import com.thaiopensource.relaxng.pattern.EndAttributesFunction;
import com.thaiopensource.relaxng.pattern.EndTagDerivFunction;
import com.thaiopensource.relaxng.pattern.IgnoreMissingAttributesFunction;
import com.thaiopensource.relaxng.pattern.MixedTextDerivFunction;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternBuilder;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.PossibleAttributeNamesFunction;
import com.thaiopensource.relaxng.pattern.PossibleNamesFunction;
import com.thaiopensource.relaxng.pattern.PossibleStartTagNamesFunction;
import com.thaiopensource.relaxng.pattern.RecoverAfterFunction;
import com.thaiopensource.relaxng.pattern.RequiredAttributesFunction;
import com.thaiopensource.relaxng.pattern.RequiredElementsFunction;
import com.thaiopensource.relaxng.pattern.TextOnlyFunction;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ValidatorPatternBuilder
extends PatternBuilder {
    private final Map<Pattern, PatternMemo> patternMemoMap = new HashMap<Pattern, PatternMemo>();
    private final PatternFunction<Pattern> endAttributesFunction;
    private final PatternFunction<Pattern> ignoreMissingAttributesFunction;
    private final PatternFunction<Pattern> endTagDerivFunction;
    private final PatternFunction<Pattern> mixedTextDerivFunction;
    private final PatternFunction<Pattern> textOnlyFunction;
    private final PatternFunction<Pattern> recoverAfterFunction;
    private final PatternFunction<DataDerivType> dataDerivTypeFunction;
    private final Map<Pattern, Pattern> choiceMap = new HashMap<Pattern, Pattern>();
    private final PatternFunction<Pattern> removeChoicesFunction = new RemoveChoicesFunction();
    private final PatternFunction<VoidValue> noteChoicesFunction = new NoteChoicesFunction();
    private final PatternFunction<Set<Name>> requiredElementsFunction = new RequiredElementsFunction();
    private final PatternFunction<Set<Name>> requiredAttributesFunction = new RequiredAttributesFunction();
    private final PossibleNamesFunction possibleStartTagNamesFunction = new PossibleStartTagNamesFunction();
    private final PossibleNamesFunction possibleAttributeNamesFunction = new PossibleAttributeNamesFunction();

    public ValidatorPatternBuilder(PatternBuilder patternBuilder) {
        super(patternBuilder);
        this.endAttributesFunction = new EndAttributesFunction(this);
        this.ignoreMissingAttributesFunction = new IgnoreMissingAttributesFunction(this);
        this.endTagDerivFunction = new EndTagDerivFunction(this);
        this.mixedTextDerivFunction = new MixedTextDerivFunction(this);
        this.textOnlyFunction = new TextOnlyFunction(this);
        this.recoverAfterFunction = new RecoverAfterFunction(this);
        this.dataDerivTypeFunction = new DataDerivTypeFunction(this);
    }

    PatternMemo getPatternMemo(Pattern pattern) {
        PatternMemo patternMemo = this.patternMemoMap.get(pattern);
        if (patternMemo == null) {
            patternMemo = new PatternMemo(pattern, this);
            this.patternMemoMap.put(pattern, patternMemo);
        }
        return patternMemo;
    }

    PatternFunction<Pattern> getEndAttributesFunction() {
        return this.endAttributesFunction;
    }

    PatternFunction<Pattern> getIgnoreMissingAttributesFunction() {
        return this.ignoreMissingAttributesFunction;
    }

    PatternFunction<Set<Name>> getRequiredElementsFunction() {
        return this.requiredElementsFunction;
    }

    PatternFunction<Set<Name>> getRequiredAttributesFunction() {
        return this.requiredAttributesFunction;
    }

    PossibleNamesFunction getPossibleStartTagNamesFunction() {
        return this.possibleStartTagNamesFunction;
    }

    PossibleNamesFunction getPossibleAttributeNamesFunction() {
        return this.possibleAttributeNamesFunction;
    }

    PatternFunction<Pattern> getEndTagDerivFunction() {
        return this.endTagDerivFunction;
    }

    PatternFunction<Pattern> getMixedTextDerivFunction() {
        return this.mixedTextDerivFunction;
    }

    PatternFunction<Pattern> getTextOnlyFunction() {
        return this.textOnlyFunction;
    }

    PatternFunction<Pattern> getRecoverAfterFunction() {
        return this.recoverAfterFunction;
    }

    PatternFunction<DataDerivType> getDataDerivTypeFunction() {
        return this.dataDerivTypeFunction;
    }

    Pattern makeAfter(Pattern pattern, Pattern pattern2) {
        AfterPattern afterPattern = new AfterPattern(pattern, pattern2);
        return this.interner.intern(afterPattern);
    }

    @Override
    Pattern makeChoice(Pattern pattern, Pattern pattern2) {
        if (pattern == pattern2) {
            return pattern;
        }
        if (pattern == this.notAllowed) {
            return pattern2;
        }
        if (pattern2 == this.notAllowed) {
            return pattern;
        }
        if (!(pattern instanceof ChoicePattern)) {
            if (pattern2.containsChoice(pattern)) {
                return pattern2;
            }
        } else if (!(pattern2 instanceof ChoicePattern)) {
            if (pattern.containsChoice(pattern2)) {
                return pattern;
            }
        } else {
            pattern.apply(this.noteChoicesFunction);
            pattern2 = pattern2.apply(this.removeChoicesFunction);
            if (this.choiceMap.size() > 0) {
                this.choiceMap.clear();
            }
            if (pattern2 == this.notAllowed) {
                return pattern;
            }
        }
        if (pattern instanceof AfterPattern && pattern2 instanceof AfterPattern) {
            AfterPattern afterPattern = (AfterPattern)pattern;
            AfterPattern afterPattern2 = (AfterPattern)pattern2;
            if (afterPattern.getOperand1() == afterPattern2.getOperand1()) {
                return this.makeAfter(afterPattern.getOperand1(), this.makeChoice(afterPattern.getOperand2(), afterPattern2.getOperand2()));
            }
            if (afterPattern.getOperand1() == this.notAllowed) {
                return afterPattern2;
            }
            if (afterPattern2.getOperand1() == this.notAllowed) {
                return afterPattern;
            }
            if (afterPattern.getOperand2() == afterPattern2.getOperand2()) {
                return this.makeAfter(this.makeChoice(afterPattern.getOperand1(), afterPattern2.getOperand1()), afterPattern.getOperand2());
            }
        }
        return super.makeChoice(pattern, pattern2);
    }

    private class RemoveChoicesFunction
    extends AbstractPatternFunction<Pattern> {
        private RemoveChoicesFunction() {
        }

        @Override
        public Pattern caseOther(Pattern pattern) {
            if (ValidatorPatternBuilder.this.choiceMap.get(pattern) != null) {
                return ValidatorPatternBuilder.this.notAllowed;
            }
            return pattern;
        }

        @Override
        public Pattern caseChoice(ChoicePattern choicePattern) {
            Pattern pattern = choicePattern.getOperand1().apply(this);
            Pattern pattern2 = choicePattern.getOperand2().apply(this);
            if (pattern == choicePattern.getOperand1() && pattern2 == choicePattern.getOperand2()) {
                return choicePattern;
            }
            if (pattern == ValidatorPatternBuilder.this.notAllowed) {
                return pattern2;
            }
            if (pattern2 == ValidatorPatternBuilder.this.notAllowed) {
                return pattern;
            }
            ChoicePattern choicePattern2 = new ChoicePattern(pattern, pattern2);
            return ValidatorPatternBuilder.this.interner.intern(choicePattern2);
        }
    }

    private class NoteChoicesFunction
    extends AbstractPatternFunction<VoidValue> {
        private NoteChoicesFunction() {
        }

        @Override
        public VoidValue caseOther(Pattern pattern) {
            ValidatorPatternBuilder.this.choiceMap.put(pattern, pattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseChoice(ChoicePattern choicePattern) {
            choicePattern.getOperand1().apply(this);
            choicePattern.getOperand2().apply(this);
            return VoidValue.VOID;
        }
    }
}

