/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.XMLValidator;
import org.eclipse.lemminx.extensions.contentmodel.settings.SchemaEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLSchemaSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.relaxng.RelaxNGPlugin;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGValidator;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityResolver;
import org.eclipse.lemminx.services.extensions.diagnostics.DiagnosticsResult;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class RNGDiagnosticsParticipant
implements IDiagnosticsParticipant {
    private final RelaxNGPlugin rngPlugin;

    public RNGDiagnosticsParticipant(RelaxNGPlugin rngPlugin) {
        this.rngPlugin = rngPlugin;
    }

    @Override
    public void doDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker monitor) {
        if (!DOMUtils.isRelaxNGXMLSyntax(xmlDocument)) {
            return;
        }
        URIResolverExtensionManager entityResolver = xmlDocument.getResolverExtensionManager();
        LSPXMLEntityResolver entityResolverWrapper = new LSPXMLEntityResolver(entityResolver, (DiagnosticsResult)diagnostics);
        ContentModelManager contentModelManager = this.rngPlugin.getContentModelManager();
        if (!RNGDiagnosticsParticipant.isSchemaEnabled(validationSettings)) {
            XMLValidator.doDiagnostics(xmlDocument, entityResolverWrapper, diagnostics, validationSettings, contentModelManager, monitor);
            return;
        }
        RNGValidator.doDiagnostics(xmlDocument, entityResolverWrapper, diagnostics, validationSettings, this.rngPlugin.getContentModelManager(), monitor);
    }

    private static boolean isSchemaEnabled(XMLValidationSettings validationSettings) {
        if (validationSettings == null) {
            return true;
        }
        XMLSchemaSettings schemaSettings = validationSettings.getSchema();
        if (schemaSettings == null) {
            return true;
        }
        return !SchemaEnabled.never.equals((Object)schemaSettings.getEnabled());
    }
}

