/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.filters;

import java.util.Hashtable;
import org.codelibs.nekohtml.filters.DefaultFilter;
import org.codelibs.xerces.xerces.xni.Augmentations;
import org.codelibs.xerces.xerces.xni.NamespaceContext;
import org.codelibs.xerces.xerces.xni.QName;
import org.codelibs.xerces.xerces.xni.XMLAttributes;
import org.codelibs.xerces.xerces.xni.XMLLocator;
import org.codelibs.xerces.xerces.xni.XMLResourceIdentifier;
import org.codelibs.xerces.xerces.xni.XMLString;

public class ElementRemover
extends DefaultFilter {
    protected static final Object NULL = new Object();
    protected Hashtable<String, Object> fAcceptedElements = new Hashtable();
    protected Hashtable<String, Object> fRemovedElements = new Hashtable();
    protected int fElementDepth;
    protected int fRemovalElementDepth;

    public void acceptElement(String element, String[] attributes) {
        String key = element.toLowerCase();
        String[] value = NULL;
        if (attributes != null) {
            String[] newarray = new String[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                newarray[i] = attributes[i].toLowerCase();
            }
            value = attributes;
        }
        this.fAcceptedElements.put(key, value);
    }

    public void removeElement(String element) {
        String key = element.toLowerCase();
        Object value = NULL;
        this.fRemovedElements.put(key, value);
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext nscontext, Augmentations augs) {
        this.fElementDepth = 0;
        this.fRemovalElementDepth = Integer.MAX_VALUE;
        super.startDocument(locator, encoding, nscontext, augs);
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) {
        this.startDocument(locator, encoding, null, augs);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.startPrefixMapping(prefix, uri, augs);
        }
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth && this.handleOpenTag(element, attributes)) {
            super.startElement(element, attributes, augs);
        }
        ++this.fElementDepth;
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth && this.handleOpenTag(element, attributes)) {
            super.emptyElement(element, attributes, augs);
        }
    }

    @Override
    public void comment(XMLString text, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.comment(text, augs);
        }
    }

    @Override
    public void processingInstruction(String target, XMLString data, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.processingInstruction(target, data, augs);
        }
    }

    @Override
    public void characters(XMLString text, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.characters(text, augs);
        }
    }

    @Override
    public void ignorableWhitespace(XMLString text, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.ignorableWhitespace(text, augs);
        }
    }

    @Override
    public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.startGeneralEntity(name, id, encoding, augs);
        }
    }

    @Override
    public void textDecl(String version, String encoding, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.textDecl(version, encoding, augs);
        }
    }

    @Override
    public void endGeneralEntity(String name, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.endGeneralEntity(name, augs);
        }
    }

    @Override
    public void startCDATA(Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.startCDATA(augs);
        }
    }

    @Override
    public void endCDATA(Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.endCDATA(augs);
        }
    }

    @Override
    public void endElement(QName element, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth && this.elementAccepted(element.rawname)) {
            super.endElement(element, augs);
        }
        --this.fElementDepth;
        if (this.fElementDepth == this.fRemovalElementDepth) {
            this.fRemovalElementDepth = Integer.MAX_VALUE;
        }
    }

    @Override
    public void endPrefixMapping(String prefix, Augmentations augs) {
        if (this.fElementDepth <= this.fRemovalElementDepth) {
            super.endPrefixMapping(prefix, augs);
        }
    }

    protected boolean elementAccepted(String element) {
        String key = element.toLowerCase();
        return this.fAcceptedElements.containsKey(key);
    }

    protected boolean elementRemoved(String element) {
        String key = element.toLowerCase();
        return this.fRemovedElements.containsKey(key);
    }

    protected boolean handleOpenTag(QName element, XMLAttributes attributes) {
        if (this.elementAccepted(element.rawname)) {
            String key = element.rawname.toLowerCase();
            Object value = this.fAcceptedElements.get(key);
            if (value != NULL) {
                String[] anames = (String[])value;
                int attributeCount = attributes.getLength();
                block0: for (int i = 0; i < attributeCount; ++i) {
                    String aname = attributes.getQName(i).toLowerCase();
                    for (String aname2 : anames) {
                        if (aname2.equals(aname)) continue block0;
                    }
                    attributes.removeAttributeAt(i--);
                    --attributeCount;
                }
            } else {
                attributes.removeAllAttributes();
            }
            return true;
        }
        if (this.elementRemoved(element.rawname)) {
            this.fRemovalElementDepth = this.fElementDepth;
        }
        return false;
    }
}

