/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import org.mandas.docker.client.ProgressHandler;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.exceptions.ImageNotFoundException;
import org.mandas.docker.client.exceptions.ImagePullFailedException;
import org.mandas.docker.client.messages.ProgressMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPullHandler
implements ProgressHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingPullHandler.class);
    private final String image;

    public LoggingPullHandler(String image) {
        this.image = image;
    }

    @Override
    public void progress(ProgressMessage message) throws DockerException {
        if (message.error() != null) {
            if (message.error().contains("404") || message.error().contains("not found")) {
                throw new ImageNotFoundException(this.image, message.toString());
            }
            throw new ImagePullFailedException(this.image, message.toString());
        }
        log.info("pull {}: {}", (Object)this.image, (Object)message);
    }
}

