/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Calendar;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.StapTreeDataFactory;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public final class TreeSettings {
    private static final String FILE_NAME = "TreeSettings";
    private static final String FILE_DIRECTORY = ".systemtapgui";
    private static final String M_DISP = "display";
    private static final String M_DATA = "data";
    private static final String M_DATATYPE = "datatype";
    private static final String M_DEFINITON = "definition";
    private static final String M_CLICKABLE = "clickable";
    private static final String M_NULL = "<null>";
    private static final String M_ITEM = "item";
    private static final String T_FUNCTIONS = "functionTree";
    private static final String T_PROBES = "probeTree";
    private static final String T_DATE = "modifiedDate";
    private static final String T_VERSION = "version";
    private static final String VERSION_NUMBER = "3.0";
    private static TreeNode cachedFunctions;
    private static TreeNode cachedProbes;
    private static File settingsFile;

    private TreeSettings() {
    }

    static boolean deleteTrees() {
        boolean deleted;
        try {
            deleted = settingsFile.delete();
        }
        catch (SecurityException e) {
            deleted = false;
        }
        if (deleted) {
            TreeSettings.clearCachedTrees();
        }
        return deleted;
    }

    public static synchronized boolean setTrees(TreeNode functions, TreeNode probes) {
        if (functions == null || probes == null || functions == cachedFunctions || probes == cachedProbes || !TreeSettings.isTreeFileAvailable()) {
            return false;
        }
        XMLMemento data = XMLMemento.createWriteRoot((String)FILE_NAME);
        TreeSettings.writeTree((IMemento)data, T_FUNCTIONS, functions);
        TreeSettings.writeTree((IMemento)data, T_PROBES, probes);
        data.createChild(T_DATE).putTextData(Long.valueOf(Calendar.getInstance().getTimeInMillis()).toString());
        data.createChild(T_VERSION).putTextData(VERSION_NUMBER);
        try (FileWriter writer = new FileWriter(settingsFile);){
            data.save((Writer)writer);
        }
        catch (IOException e) {
            return false;
        }
        TreeSettings.clearCachedTrees();
        return true;
    }

    private static void writeTree(IMemento data, String name, TreeNode tree) {
        IMemento child = data.createChild(name);
        child.putString(M_DISP, tree.toString());
        Object treeData = tree.getData();
        if (treeData != null) {
            child.putString(M_DATA, treeData.toString());
            child.putString(M_DATATYPE, StapTreeDataFactory.getDataObjectID(treeData));
        }
        if (tree instanceof TreeDefinitionNode) {
            child.putString(M_DEFINITON, TreeSettings.getStringFromValue(((TreeDefinitionNode)tree).getDefinition()));
        }
        child.putBoolean(M_CLICKABLE, tree.isClickable());
        int n = tree.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeSettings.writeTree(child, M_ITEM, tree.getChildAt(i));
        }
    }

    private static void clearCachedTrees() {
        cachedFunctions = null;
        cachedProbes = null;
    }

    public static synchronized TreeNode getFunctionTree() {
        if (cachedFunctions == null) {
            cachedFunctions = TreeSettings.readData(T_FUNCTIONS);
        }
        return cachedFunctions;
    }

    public static synchronized TreeNode getProbeTree() {
        if (cachedProbes == null) {
            cachedProbes = TreeSettings.readData(T_PROBES);
        }
        return cachedProbes;
    }

    private static TreeNode readData(String section) {
        IMemento data = TreeSettings.getTreeFileMemento();
        if (data == null) {
            return null;
        }
        return TreeSettings.readTree(data.getChild(section));
    }

    private static TreeNode readTree(IMemento data) {
        String disp = data.getString(M_DISP);
        String def = data.getString(M_DEFINITON);
        boolean c = data.getBoolean(M_CLICKABLE);
        Object d = StapTreeDataFactory.createObjectFromString(data.getString(M_DATA), data.getString(M_DATATYPE));
        Object parent = def == null ? new TreeNode(d, disp, c) : new TreeDefinitionNode(d, disp, TreeSettings.getValueFromString(def), c);
        for (IMemento child : data.getChildren()) {
            parent.add(TreeSettings.readTree(child));
        }
        return parent;
    }

    public static synchronized long getTreeFileDate() {
        IMemento data = TreeSettings.getTreeFileMemento();
        if (data != null) {
            IMemento child = data.getChild(T_DATE);
            try {
                return Long.parseLong(child.getTextData());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IMemento getTreeFileMemento() {
        if (!TreeSettings.isTreeFileAvailable()) {
            return null;
        }
        try (FileReader reader = new FileReader(settingsFile);){
            XMLMemento data = XMLMemento.createReadRoot((Reader)reader, (String)FILE_NAME);
            IMemento versionChild = data.getChild(T_VERSION);
            if (versionChild != null && versionChild.getTextData().equals(VERSION_NUMBER)) {
                XMLMemento xMLMemento = data;
                return xMLMemento;
            }
            IMemento iMemento = null;
            return iMemento;
        }
        catch (IOException | WorkbenchException fnfe) {
            return null;
        }
    }

    private static boolean isTreeFileAvailable() {
        if (settingsFile != null) {
            return true;
        }
        IPath path = new Path(System.getenv("HOME")).append(FILE_DIRECTORY).append(FILE_NAME).addFileExtension("xml");
        settingsFile = path.toFile();
        try {
            if (!settingsFile.exists()) {
                settingsFile.getParentFile().mkdirs();
                settingsFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    private static String getStringFromValue(String val) {
        return val == null ? M_NULL : val;
    }

    private static String getValueFromString(String string) {
        return M_NULL.equals(string) ? null : string;
    }

    static {
        settingsFile = null;
    }
}

