/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EditorToOutlineAdapterFactory
implements IAdapterFactory {
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final Map<IEditorPart, LanguageServerWrapper> LANG_SERVER_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public <T> @Nullable T getAdapter(@Nullable Object adaptableObject, @Nullable Class<T> adapterType) {
        IEditorPart editorPart;
        IEditorInput editorInput;
        if (adapterType == IContentOutlinePage.class && adaptableObject instanceof IEditorPart && (editorInput = (editorPart = (IEditorPart)adaptableObject).getEditorInput()) != null && LanguageServersRegistry.getInstance().canUseLanguageServer(editorInput)) {
            LanguageServerWrapper server = LANG_SERVER_CACHE.remove(editorPart);
            if (server != null && server.isActive()) {
                return adapterType.cast(EditorToOutlineAdapterFactory.createOutlinePage(editorPart, server));
            }
            IDocument document = LSPEclipseUtils.getDocument(editorInput);
            if (document != null) {
                CompletableFuture<Optional<LanguageServerWrapper>> languageServer = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDocumentSymbolProvider)).computeFirst((wrapper, ls) -> CompletableFuture.completedFuture(wrapper));
                try {
                    return languageServer.get(50L, TimeUnit.MILLISECONDS).filter(LanguageServerWrapper::isActive).map(s -> adapterType.cast(EditorToOutlineAdapterFactory.createOutlinePage(editorPart, s))).orElse(null);
                }
                catch (TimeoutException e) {
                    EditorToOutlineAdapterFactory.refreshContentOutlineAsync(languageServer, editorPart);
                }
                catch (ExecutionException e) {
                    LanguageServerPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    LanguageServerPlugin.logError(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IContentOutlinePage.class};
    }

    private static CNFOutlinePage createOutlinePage(IEditorPart editorPart, LanguageServerWrapper wrapper) {
        return new CNFOutlinePage(wrapper, UI.asTextEditor(editorPart));
    }

    private static void refreshContentOutlineAsync(CompletableFuture<Optional<LanguageServerWrapper>> wrapperFuture, IEditorPart editorPart) {
        wrapperFuture.thenAcceptAsync(wrapper -> {
            if (wrapper.isPresent()) {
                Display.getDefault().asyncExec(() -> {
                    IViewPart viewPart;
                    IWorkbenchPage page = UI.getActivePage();
                    if (page != null && (viewPart = page.findView(OUTLINE_VIEW_ID)) instanceof ContentOutline) {
                        ContentOutline contentOutline = (ContentOutline)viewPart;
                        LANG_SERVER_CACHE.put(editorPart, (LanguageServerWrapper)wrapper.get());
                        contentOutline.partActivated((IWorkbenchPart)editorPart);
                    }
                });
            }
        });
    }
}

