package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link RaftConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRaftConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableRaftConfig implements RaftConfig {
  private final @Nullable Integer snapshotInterval;
  private final @Nullable Integer keepOldSnapshots;
  private final @Nullable Integer logEntriesForSlowFollowers;
  private final @Nullable Integer electionTick;
  private final @Nullable Integer heartbeatTick;

  private ImmutableRaftConfig(
      @Nullable Integer snapshotInterval,
      @Nullable Integer keepOldSnapshots,
      @Nullable Integer logEntriesForSlowFollowers,
      @Nullable Integer electionTick,
      @Nullable Integer heartbeatTick) {
    this.snapshotInterval = snapshotInterval;
    this.keepOldSnapshots = keepOldSnapshots;
    this.logEntriesForSlowFollowers = logEntriesForSlowFollowers;
    this.electionTick = electionTick;
    this.heartbeatTick = heartbeatTick;
  }

  /**
   * @return The value of the {@code snapshotInterval} attribute
   */
  @JsonProperty("SnapshotInterval")
  @Override
  public @Nullable Integer snapshotInterval() {
    return snapshotInterval;
  }

  /**
   * @return The value of the {@code keepOldSnapshots} attribute
   */
  @JsonProperty("KeepOldSnapshots")
  @Override
  public @Nullable Integer keepOldSnapshots() {
    return keepOldSnapshots;
  }

  /**
   * @return The value of the {@code logEntriesForSlowFollowers} attribute
   */
  @JsonProperty("LogEntriesForSlowFollowers")
  @Override
  public @Nullable Integer logEntriesForSlowFollowers() {
    return logEntriesForSlowFollowers;
  }

  /**
   * @return The value of the {@code electionTick} attribute
   */
  @JsonProperty("ElectionTick")
  @Override
  public @Nullable Integer electionTick() {
    return electionTick;
  }

  /**
   * @return The value of the {@code heartbeatTick} attribute
   */
  @JsonProperty("HeartbeatTick")
  @Override
  public @Nullable Integer heartbeatTick() {
    return heartbeatTick;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftConfig#snapshotInterval() snapshotInterval} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for snapshotInterval (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftConfig withSnapshotInterval(@Nullable Integer value) {
    if (Objects.equals(this.snapshotInterval, value)) return this;
    return new ImmutableRaftConfig(
        value,
        this.keepOldSnapshots,
        this.logEntriesForSlowFollowers,
        this.electionTick,
        this.heartbeatTick);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftConfig#keepOldSnapshots() keepOldSnapshots} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keepOldSnapshots (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftConfig withKeepOldSnapshots(@Nullable Integer value) {
    if (Objects.equals(this.keepOldSnapshots, value)) return this;
    return new ImmutableRaftConfig(
        this.snapshotInterval,
        value,
        this.logEntriesForSlowFollowers,
        this.electionTick,
        this.heartbeatTick);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftConfig#logEntriesForSlowFollowers() logEntriesForSlowFollowers} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logEntriesForSlowFollowers (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftConfig withLogEntriesForSlowFollowers(@Nullable Integer value) {
    if (Objects.equals(this.logEntriesForSlowFollowers, value)) return this;
    return new ImmutableRaftConfig(this.snapshotInterval, this.keepOldSnapshots, value, this.electionTick, this.heartbeatTick);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftConfig#electionTick() electionTick} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for electionTick (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftConfig withElectionTick(@Nullable Integer value) {
    if (Objects.equals(this.electionTick, value)) return this;
    return new ImmutableRaftConfig(
        this.snapshotInterval,
        this.keepOldSnapshots,
        this.logEntriesForSlowFollowers,
        value,
        this.heartbeatTick);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftConfig#heartbeatTick() heartbeatTick} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for heartbeatTick (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftConfig withHeartbeatTick(@Nullable Integer value) {
    if (Objects.equals(this.heartbeatTick, value)) return this;
    return new ImmutableRaftConfig(
        this.snapshotInterval,
        this.keepOldSnapshots,
        this.logEntriesForSlowFollowers,
        this.electionTick,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRaftConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRaftConfig
        && equalTo(0, (ImmutableRaftConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableRaftConfig another) {
    return Objects.equals(snapshotInterval, another.snapshotInterval)
        && Objects.equals(keepOldSnapshots, another.keepOldSnapshots)
        && Objects.equals(logEntriesForSlowFollowers, another.logEntriesForSlowFollowers)
        && Objects.equals(electionTick, another.electionTick)
        && Objects.equals(heartbeatTick, another.heartbeatTick);
  }

  /**
   * Computes a hash code from attributes: {@code snapshotInterval}, {@code keepOldSnapshots}, {@code logEntriesForSlowFollowers}, {@code electionTick}, {@code heartbeatTick}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(snapshotInterval);
    h += (h << 5) + Objects.hashCode(keepOldSnapshots);
    h += (h << 5) + Objects.hashCode(logEntriesForSlowFollowers);
    h += (h << 5) + Objects.hashCode(electionTick);
    h += (h << 5) + Objects.hashCode(heartbeatTick);
    return h;
  }

  /**
   * Prints the immutable value {@code RaftConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RaftConfig{"
        + "snapshotInterval=" + snapshotInterval
        + ", keepOldSnapshots=" + keepOldSnapshots
        + ", logEntriesForSlowFollowers=" + logEntriesForSlowFollowers
        + ", electionTick=" + electionTick
        + ", heartbeatTick=" + heartbeatTick
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RaftConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RaftConfig instance
   */
  public static ImmutableRaftConfig copyOf(RaftConfig instance) {
    if (instance instanceof ImmutableRaftConfig) {
      return (ImmutableRaftConfig) instance;
    }
    return ImmutableRaftConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRaftConfig ImmutableRaftConfig}.
   * <pre>
   * ImmutableRaftConfig.builder()
   *    .snapshotInterval(Integer | null) // nullable {@link RaftConfig#snapshotInterval() snapshotInterval}
   *    .keepOldSnapshots(Integer | null) // nullable {@link RaftConfig#keepOldSnapshots() keepOldSnapshots}
   *    .logEntriesForSlowFollowers(Integer | null) // nullable {@link RaftConfig#logEntriesForSlowFollowers() logEntriesForSlowFollowers}
   *    .electionTick(Integer | null) // nullable {@link RaftConfig#electionTick() electionTick}
   *    .heartbeatTick(Integer | null) // nullable {@link RaftConfig#heartbeatTick() heartbeatTick}
   *    .build();
   * </pre>
   * @return A new ImmutableRaftConfig builder
   */
  public static ImmutableRaftConfig.Builder builder() {
    return new ImmutableRaftConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRaftConfig ImmutableRaftConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements RaftConfig.Builder {
    private Integer snapshotInterval;
    private Integer keepOldSnapshots;
    private Integer logEntriesForSlowFollowers;
    private Integer electionTick;
    private Integer heartbeatTick;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RaftConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RaftConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer snapshotIntervalValue = instance.snapshotInterval();
      if (snapshotIntervalValue != null) {
        snapshotInterval(snapshotIntervalValue);
      }
      @Nullable Integer keepOldSnapshotsValue = instance.keepOldSnapshots();
      if (keepOldSnapshotsValue != null) {
        keepOldSnapshots(keepOldSnapshotsValue);
      }
      @Nullable Integer logEntriesForSlowFollowersValue = instance.logEntriesForSlowFollowers();
      if (logEntriesForSlowFollowersValue != null) {
        logEntriesForSlowFollowers(logEntriesForSlowFollowersValue);
      }
      @Nullable Integer electionTickValue = instance.electionTick();
      if (electionTickValue != null) {
        electionTick(electionTickValue);
      }
      @Nullable Integer heartbeatTickValue = instance.heartbeatTick();
      if (heartbeatTickValue != null) {
        heartbeatTick(heartbeatTickValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RaftConfig#snapshotInterval() snapshotInterval} attribute.
     * @param snapshotInterval The value for snapshotInterval (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SnapshotInterval")
    public final Builder snapshotInterval(@Nullable Integer snapshotInterval) {
      this.snapshotInterval = snapshotInterval;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftConfig#keepOldSnapshots() keepOldSnapshots} attribute.
     * @param keepOldSnapshots The value for keepOldSnapshots (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("KeepOldSnapshots")
    public final Builder keepOldSnapshots(@Nullable Integer keepOldSnapshots) {
      this.keepOldSnapshots = keepOldSnapshots;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftConfig#logEntriesForSlowFollowers() logEntriesForSlowFollowers} attribute.
     * @param logEntriesForSlowFollowers The value for logEntriesForSlowFollowers (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LogEntriesForSlowFollowers")
    public final Builder logEntriesForSlowFollowers(@Nullable Integer logEntriesForSlowFollowers) {
      this.logEntriesForSlowFollowers = logEntriesForSlowFollowers;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftConfig#electionTick() electionTick} attribute.
     * @param electionTick The value for electionTick (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ElectionTick")
    public final Builder electionTick(@Nullable Integer electionTick) {
      this.electionTick = electionTick;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftConfig#heartbeatTick() heartbeatTick} attribute.
     * @param heartbeatTick The value for heartbeatTick (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HeartbeatTick")
    public final Builder heartbeatTick(@Nullable Integer heartbeatTick) {
      this.heartbeatTick = heartbeatTick;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRaftConfig ImmutableRaftConfig}.
     * @return An immutable instance of RaftConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRaftConfig build() {
      return new ImmutableRaftConfig(snapshotInterval, keepOldSnapshots, logEntriesForSlowFollowers, electionTick, heartbeatTick);
    }
  }
}
