/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ContainerStatus;
import org.mandas.docker.client.messages.swarm.TaskStatus;

final class ImmutableTaskStatus
implements TaskStatus {
    private final Date timestamp;
    private final String state;
    private final String message;
    @Nullable
    private final String err;
    @Nullable
    private final ContainerStatus containerStatus;

    private ImmutableTaskStatus(Date timestamp, String state, String message, @Nullable String err, @Nullable ContainerStatus containerStatus) {
        this.timestamp = timestamp;
        this.state = state;
        this.message = message;
        this.err = err;
        this.containerStatus = containerStatus;
    }

    @Override
    @JsonProperty(value="Timestamp")
    public Date timestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="State")
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty(value="Message")
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty(value="Err")
    @Nullable
    public String err() {
        return this.err;
    }

    @Override
    @JsonProperty(value="ContainerStatus")
    @Nullable
    public ContainerStatus containerStatus() {
        return this.containerStatus;
    }

    public final ImmutableTaskStatus withTimestamp(Date value) {
        if (this.timestamp == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "timestamp");
        return new ImmutableTaskStatus(newValue, this.state, this.message, this.err, this.containerStatus);
    }

    public final ImmutableTaskStatus withState(String value) {
        String newValue = Objects.requireNonNull(value, "state");
        if (this.state.equals(newValue)) {
            return this;
        }
        return new ImmutableTaskStatus(this.timestamp, newValue, this.message, this.err, this.containerStatus);
    }

    public final ImmutableTaskStatus withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableTaskStatus(this.timestamp, this.state, newValue, this.err, this.containerStatus);
    }

    public final ImmutableTaskStatus withErr(@Nullable String value) {
        if (Objects.equals(this.err, value)) {
            return this;
        }
        return new ImmutableTaskStatus(this.timestamp, this.state, this.message, value, this.containerStatus);
    }

    public final ImmutableTaskStatus withContainerStatus(@Nullable ContainerStatus value) {
        if (this.containerStatus == value) {
            return this;
        }
        return new ImmutableTaskStatus(this.timestamp, this.state, this.message, this.err, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskStatus && this.equalsByValue((ImmutableTaskStatus)another);
    }

    private boolean equalsByValue(ImmutableTaskStatus another) {
        return this.timestamp.equals(another.timestamp) && this.state.equals(another.state) && this.message.equals(another.message) && Objects.equals(this.err, another.err) && Objects.equals(this.containerStatus, another.containerStatus);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.timestamp.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.err);
        h += (h << 5) + Objects.hashCode(this.containerStatus);
        return h;
    }

    public String toString() {
        return "TaskStatus{timestamp=" + String.valueOf(this.timestamp) + ", state=" + this.state + ", message=" + this.message + ", err=" + this.err + ", containerStatus=" + String.valueOf(this.containerStatus) + "}";
    }

    public static ImmutableTaskStatus copyOf(TaskStatus instance) {
        if (instance instanceof ImmutableTaskStatus) {
            return (ImmutableTaskStatus)instance;
        }
        return ImmutableTaskStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_TIMESTAMP = 1L;
        private static final long INIT_BIT_STATE = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private long initBits = 7L;
        private Date timestamp;
        private String state;
        private String message;
        private String err;
        private ContainerStatus containerStatus;

        private Builder() {
        }

        public final Builder from(TaskStatus instance) {
            ContainerStatus containerStatusValue;
            Objects.requireNonNull(instance, "instance");
            this.timestamp(instance.timestamp());
            this.state(instance.state());
            this.message(instance.message());
            String errValue = instance.err();
            if (errValue != null) {
                this.err(errValue);
            }
            if ((containerStatusValue = instance.containerStatus()) != null) {
                this.containerStatus(containerStatusValue);
            }
            return this;
        }

        @JsonProperty(value="Timestamp")
        public final Builder timestamp(Date timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="State")
        public final Builder state(String state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Message")
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Err")
        public final Builder err(@Nullable String err) {
            this.err = err;
            return this;
        }

        @JsonProperty(value="ContainerStatus")
        public final Builder containerStatus(@Nullable ContainerStatus containerStatus) {
            this.containerStatus = containerStatus;
            return this;
        }

        public ImmutableTaskStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskStatus(this.timestamp, this.state, this.message, this.err, this.containerStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build TaskStatus, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

