/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.ProcessLauncher;
import org.eclipse.linuxtools.internal.docker.core.SystemUtils;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;

public class DockerCompose {
    private static DockerCompose instance = new DockerCompose();
    private ProcessLauncher processLauncher = new ProcessLauncher();

    public static DockerCompose getInstance() {
        return instance;
    }

    private DockerCompose() {
    }

    public void setProcessLauncher(ProcessLauncher processLauncher) {
        this.processLauncher = processLauncher;
    }

    public boolean checkPathToDockerCompose(String dockerComposeInstallDir) {
        return this.processLauncher.checkPathToCommand(dockerComposeInstallDir, DockerCompose.getDockerComposeCommandName());
    }

    public Process up(IDockerConnection connection, String dockerComposeInstallDir, String baseDir) throws DockerException {
        return this.processLauncher.processBuilder(dockerComposeInstallDir, DockerCompose.getDockerComposeCommandName(), DockerCompose.getArguments(connection, "up")).workingDir(baseDir).start();
    }

    public Process stop(IDockerConnection connection, String dockerComposeInstallDir, String baseDir) throws DockerException {
        return this.processLauncher.processBuilder(dockerComposeInstallDir, DockerCompose.getDockerComposeCommandName(), DockerCompose.getArguments(connection, "stop")).workingDir(baseDir).start();
    }

    private static String[] getArguments(IDockerConnection connection, String commandName) {
        switch (connection.getSettings().getType()) {
            case UNIX_SOCKET_CONNECTION: {
                return new String[]{commandName};
            }
            case TCP_CONNECTION: {
                TCPConnectionSettings connectionSettings = (TCPConnectionSettings)connection.getSettings();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-H");
                args.add(connectionSettings.getHost());
                if (connectionSettings.isTlsVerify() && connectionSettings.getPathToCertificates() != null) {
                    args.add("--tlsverify");
                    args.add("--tlscacert");
                    args.add(DockerCompose.getFilePath(connectionSettings.getPathToCertificates(), "ca.pem"));
                    args.add("--tlscert");
                    args.add(DockerCompose.getFilePath(connectionSettings.getPathToCertificates(), "cert.pem"));
                    args.add("--tlskey");
                    args.add(DockerCompose.getFilePath(connectionSettings.getPathToCertificates(), "key.pem"));
                }
                args.add(commandName);
                return args.toArray(new String[0]);
            }
        }
        return null;
    }

    private static String getFilePath(String pathToCertificates, String certificateFileName) {
        if (pathToCertificates.endsWith(File.separator)) {
            return pathToCertificates + certificateFileName;
        }
        return pathToCertificates + File.separator + certificateFileName;
    }

    public static String getDockerComposeCommandName() {
        if (SystemUtils.isWindows()) {
            return "docker-compose.exe";
        }
        return "docker-compose";
    }
}

