/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algebra;

public class Value
implements Comparable<Value> {
    public static final Value NEGATIVE_INFINITY = new Value(Double.NEGATIVE_INFINITY);
    public static final Value POSITIVE_INFINITY = new Value(Double.POSITIVE_INFINITY);
    private final Double value;

    public Value(double value) {
        this.value = value;
    }

    public Value abs() {
        return new Value(Math.abs(this.value));
    }

    public Value max(Value other) {
        return new Value(Math.max(this.value, other.value));
    }

    public Value min(Value other) {
        return new Value(Math.min(this.value, other.value));
    }

    public Value add(Value other) {
        return new Value(this.value + other.value);
    }

    public Value multiply(Value other) {
        return new Value(this.value * other.value);
    }

    public Value divide(Value other) {
        return new Value(this.value / other.value);
    }

    public Value subtract(Value other) {
        assert (!other.equals(NEGATIVE_INFINITY));
        return new Value(this.value - other.value);
    }

    public static Value max(Value a, Value b) {
        return a.max(b);
    }

    public int signum() {
        Double signum = Math.signum(this.value);
        return signum.intValue();
    }

    public boolean smallerThan(Value other) {
        return this.value.compareTo(other.value) < 0;
    }

    public boolean biggerThan(Value other) {
        return this.value.compareTo(other.value) > 0;
    }

    public Double toDouble() {
        return (double)this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value value1 = (Value)o;
        return this.value.equals(value1.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int compareTo(Value o) {
        return this.value.compareTo(o.value);
    }

    public Double getValue() {
        return this.value;
    }
}

