/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;

public class BufferedDiagnosticChain
implements DiagnosticChain {
    private final Collection<Diagnostic> buffer;
    private final boolean unique;
    private DiagnosticChain delegate = null;
    private int maxSeverity = 0;

    public BufferedDiagnosticChain() {
        this(null, false);
    }

    public BufferedDiagnosticChain(DiagnosticChain delegate) {
        this(delegate, false);
    }

    public BufferedDiagnosticChain(DiagnosticChain delegate, boolean unique) {
        this.delegate = delegate;
        this.unique = unique;
        this.buffer = unique ? new LinkedHashSet() : new LinkedList();
    }

    public int getMaxSeverity() {
        return this.maxSeverity;
    }

    public Collection<Diagnostic> getDiagnostics() {
        return Collections.unmodifiableCollection(this.buffer);
    }

    public void add(Diagnostic diagnostic) {
        if (this.buffer.add(this.wrap(diagnostic)) && this.delegate != null) {
            this.maxSeverity = Math.max(this.maxSeverity, diagnostic.getSeverity());
            this.delegate.add(diagnostic);
        }
    }

    public void addAll(Diagnostic diagnostic) {
        for (Diagnostic child : diagnostic.getChildren()) {
            this.add(child);
        }
    }

    public void merge(Diagnostic diagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            this.add(diagnostic);
        } else {
            this.addAll(diagnostic);
        }
    }

    private Diagnostic wrap(Diagnostic diagnostic) {
        return this.unique ? new UniqueDiagnostic(diagnostic) : diagnostic;
    }

    private static class UniqueDiagnostic
    implements Diagnostic {
        private final Diagnostic delegate;

        private UniqueDiagnostic(Diagnostic delegate) {
            this.delegate = delegate;
        }

        public int getSeverity() {
            return this.delegate.getSeverity();
        }

        public String getMessage() {
            return this.delegate.getMessage();
        }

        public String getSource() {
            return this.delegate.getSource();
        }

        public int getCode() {
            return this.delegate.getCode();
        }

        public Throwable getException() {
            return this.delegate.getException();
        }

        public List<?> getData() {
            return this.delegate.getData();
        }

        public List<Diagnostic> getChildren() {
            return this.delegate.getChildren();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getChildren() == null ? 0 : this.getChildren().hashCode());
            result = 31 * result + this.getCode();
            result = 31 * result + (this.getData() == null ? 0 : this.getData().hashCode());
            result = 31 * result + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
            result = 31 * result + this.getSeverity();
            result = 31 * result + (this.getSource() == null ? 0 : this.getSource().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Diagnostic other = (Diagnostic)obj;
            if (this.getChildren() == null ? other.getChildren() != null : !this.getChildren().equals(other.getChildren())) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            if (this.getData() == null ? other.getData() != null : !this.getData().equals(other.getData())) {
                return false;
            }
            if (this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage())) {
                return false;
            }
            if (this.getSeverity() != other.getSeverity()) {
                return false;
            }
            return !(this.getSource() == null ? other.getSource() != null : !this.getSource().equals(other.getSource()));
        }
    }
}

