/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.text.edits.TextEditGroup;

public final class SplitTryResourceFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public SplitTryResourceFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
    }

    public static boolean initialConditionsCheck(ICompilationUnit compilationUnit, ASTNode node) {
        TryStatement tryStatement;
        VariableDeclarationExpression varDeclExp;
        if (!JavaModelUtil.is1d8OrHigher(compilationUnit.getJavaProject())) {
            return false;
        }
        ASTNode foundNode = ASTNodes.getFirstAncestorOrNull(node, VariableDeclarationExpression.class, Statement.class);
        if (!(foundNode instanceof VariableDeclarationExpression) || (varDeclExp = (VariableDeclarationExpression)foundNode).getLocationInParent() != TryStatement.RESOURCES2_PROPERTY) {
            return false;
        }
        ASTNode parent = foundNode.getParent();
        return parent instanceof TryStatement && (tryStatement = (TryStatement)parent).resources().size() >= 2;
    }

    public static SplitTryResourceFixCore createSplitVariableFix(CompilationUnit compilationUnit, ASTNode node) {
        TryStatement tryStatement;
        VariableDeclarationExpression varDeclExp;
        ASTNode foundNode = ASTNodes.getFirstAncestorOrNull(node, VariableDeclarationExpression.class, Statement.class);
        if (!(foundNode instanceof VariableDeclarationExpression) || (varDeclExp = (VariableDeclarationExpression)foundNode).getLocationInParent() != TryStatement.RESOURCES2_PROPERTY) {
            return null;
        }
        ASTNode parent = foundNode.getParent();
        if (!(parent instanceof TryStatement) || (tryStatement = (TryStatement)parent).resources().size() < 2) {
            return null;
        }
        return new SplitTryResourceFixCore(CorrectionMessages.QuickAssistProcessor_splittryresource_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{new SplitTryResourceProposalOperation(tryStatement, varDeclExp)});
    }

    private static class SplitTryResourceProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final TryStatement tryStatement;
        private final VariableDeclarationExpression expression;

        public SplitTryResourceProposalOperation(TryStatement statement, VariableDeclarationExpression expression) {
            this.tryStatement = statement;
            this.expression = expression;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            String tab_option;
            IJavaProject project;
            TextEditGroup group = null;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getAST();
            ICompilationUnit cu = cuRewrite.getCu();
            CompilationUnit root = (CompilationUnit)this.tryStatement.getRoot();
            IBuffer cuBuffer = cu.getBuffer();
            List resources = this.tryStatement.resources();
            TryStatement newTryStatement = ast.newTryStatement();
            IJavaElement rootElement = cuRewrite.getRoot().getJavaElement();
            Object fIndent = "\t";
            if (rootElement != null && (project = rootElement.getJavaProject()) != null && "space".equals(tab_option = project.getOption("org.eclipse.jdt.core.formatter.tabulation.char", true))) {
                fIndent = "";
                int i = 0;
                while (i < CodeFormatterUtil.getTabWidth(project)) {
                    fIndent = (String)fIndent + " ";
                    ++i;
                }
            }
            boolean copyResources = false;
            Object prefix = "";
            for (VariableDeclarationExpression resource : resources) {
                if (resource.equals((Object)this.expression)) {
                    copyResources = true;
                }
                if (!copyResources) continue;
                int start = root.getExtendedStartPosition((ASTNode)resource);
                int length = root.getExtendedLength((ASTNode)resource);
                StringBuffer buffer = new StringBuffer((String)prefix);
                buffer.append(cuBuffer.getText(start, length));
                VariableDeclarationExpression newVarExpression = (VariableDeclarationExpression)rewrite.createStringPlaceholder(buffer.toString(), 58);
                newTryStatement.resources().add(newVarExpression);
                rewrite.remove((ASTNode)resource, group);
                prefix = "\n" + (String)fIndent + (String)fIndent;
            }
            Block originalBlock = this.tryStatement.getBody();
            List originalStatements = originalBlock.statements();
            ListRewrite originalBlockListRewrite = rewrite.getListRewrite((ASTNode)originalBlock, Block.STATEMENTS_PROPERTY);
            StringBuilder buf = new StringBuilder();
            buf.append("{\n");
            for (Statement s : originalStatements) {
                int start = root.getExtendedStartPosition((ASTNode)s);
                int length = root.getExtendedLength((ASTNode)s);
                String text = cuBuffer.getText(start, length);
                buf.append((String)fIndent).append(text).append("\n");
                rewrite.remove((ASTNode)s, group);
            }
            buf.append("}");
            Block newBlock = (Block)rewrite.createStringPlaceholder(buf.toString(), 8);
            newTryStatement.setBody(newBlock);
            originalBlockListRewrite.insertFirst((ASTNode)newTryStatement, group);
        }
    }
}

