/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.SpecializedMapTypeIdImpl;

public class GeneralizedMapTypeIdImpl
extends GeneralizedTypeIdImpl<MapTypeId>
implements MapTypeId {
    private static int computeHashCode(@NonNull String name) {
        return IdHash.createGlobalHash(MapTypeId.class, name);
    }

    public GeneralizedMapTypeIdImpl(@NonNull IdManager idManager, @NonNull String name) {
        super(GeneralizedMapTypeIdImpl.computeHashCode(name), 2, name);
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitMapTypeId(this);
    }

    @Override
    protected @NonNull MapTypeId createSpecializedId(@NonNull BindingsId bindingsId) {
        return new SpecializedMapTypeIdImpl(this, bindingsId);
    }

    @Override
    public @NonNull String getDisplayName() {
        return this.name;
    }

    @Override
    public @NonNull MapTypeId getGeneralizedId() {
        return this;
    }

    @Override
    public @NonNull TemplateParameterId getKeyTypeId() {
        return TypeId.T_1;
    }

    @Override
    public @Nullable String getLiteralName() {
        return "MAP";
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return String.valueOf(this.name) + "Type";
    }

    @Override
    public @NonNull TemplateParameterId getValueTypeId() {
        return TypeId.T_2;
    }

    @Override
    public boolean isKeysAreNullFree() {
        return false;
    }

    @Override
    public boolean isValuesAreNullFree() {
        return false;
    }

    @Override
    public @NonNull MapTypeId specialize(@NonNull BindingsId templateBindings) {
        return (MapTypeId)this.getSpecializedId(templateBindings);
    }

    public static class MapTypeIdSingletonScope
    extends AbstractSingletonScope<MapTypeId, String> {
        public @NonNull MapTypeId getSingleton(@NonNull IdManager idManager, @NonNull String value) {
            return this.getSingletonFor(new MapTypeIdValue(idManager, value));
        }
    }

    private static class MapTypeIdValue
    extends SingletonScope.AbstractKeyAndValue<MapTypeId> {
        private final @NonNull IdManager idManager;
        private final @NonNull String value;

        public MapTypeIdValue(@NonNull IdManager idManager, @NonNull String value) {
            super(GeneralizedMapTypeIdImpl.computeHashCode(value));
            this.idManager = idManager;
            this.value = value;
        }

        @Override
        public @NonNull MapTypeId createSingleton() {
            return new GeneralizedMapTypeIdImpl(this.idManager, this.value);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof GeneralizedMapTypeIdImpl) {
                GeneralizedMapTypeIdImpl singleton = (GeneralizedMapTypeIdImpl)that;
                return singleton.getName().equals(this.value);
            }
            return false;
        }
    }
}

