/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.compaction.oned.CompareFuzzy;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;

public final class VerticalSegment
implements Comparable<VerticalSegment> {
    public CNode parentNode;
    public double relativePosition;
    public KVector bend1;
    public KVector bend2;
    public KVectorChain junctionPoints = new KVectorChain();
    public double x1;
    public double y1;
    public double y2;
    public LEdge lEdge;
    public boolean blockTopSpacing = true;
    public boolean blockBottomSpacing = false;

    public VerticalSegment(KVector bend1, KVector bend2, CNode cNode, LEdge lEdge) {
        this.bend1 = bend1;
        this.bend2 = bend2;
        if (bend1.y < bend2.y) {
            this.x1 = bend1.x;
            this.y1 = bend1.y;
            this.y2 = bend2.y;
        } else {
            this.x1 = bend2.x;
            this.y1 = bend2.y;
            this.y2 = bend1.y;
        }
        KVectorChain inJPs = (KVectorChain)lEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        if (inJPs != null) {
            for (KVector jp : inJPs) {
                if (!CompareFuzzy.eq(jp.x, bend1.x)) continue;
                this.junctionPoints.add((Object)jp);
            }
        }
        this.parentNode = cNode;
        if (this.parentNode != null) {
            this.relativePosition = this.x1 - cNode.hitbox.x;
        }
        this.lEdge = lEdge;
    }

    public boolean intersects(VerticalSegment o) {
        return CompareFuzzy.eq(this.x1, o.x1) && !CompareFuzzy.lt(this.y2, o.y1) && !CompareFuzzy.lt(o.y2, this.y1);
    }

    @Override
    public int compareTo(VerticalSegment o) {
        int d = Double.compare(this.x1, o.x1);
        if (d == 0) {
            return Double.compare(this.y1, o.y1);
        }
        return d;
    }
}

