/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algebra;

import org.eclipse.lsat.common.ludus.backend.algebra.DenseMatrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algebra.Vector;

public abstract class Matrix
implements Comparable<Matrix> {
    public abstract void put(int var1, int var2, Value var3);

    public abstract Value get(int var1, int var2);

    public abstract int getColumns();

    public abstract int getRows();

    public Vector multiply(Vector vector) {
        assert (this.getColumns() == vector.size().intValue());
        Vector result = new Vector(vector.size());
        int i = 0;
        while (i < vector.size()) {
            Value newVal = vector.get(i);
            int j = 0;
            while (j < this.getColumns()) {
                Value newTerm = vector.get(j).add(this.get(i, j));
                newVal = newVal.max(newTerm);
                ++j;
            }
            result.put(i, newVal);
            ++i;
        }
        return result;
    }

    public Matrix multiply(Matrix matrix) {
        assert (this.getColumns() == matrix.getRows());
        DenseMatrix result = new DenseMatrix(this.getRows(), matrix.getColumns());
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < matrix.getColumns()) {
                Value v = Value.NEGATIVE_INFINITY;
                int k = 0;
                while (k < this.getColumns()) {
                    v = v.max(this.get(row, k).add(matrix.get(k, col)));
                    ++k;
                }
                ((Matrix)result).put(row, col, v);
                ++col;
            }
            ++row;
        }
        return result;
    }

    public Matrix max(Matrix matrix) {
        assert (this.getColumns() == matrix.getColumns() && this.getRows() == matrix.getRows());
        DenseMatrix result = new DenseMatrix(this.getRows(), matrix.getColumns());
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getColumns()) {
                ((Matrix)result).put(row, col, this.get(row, col).max(matrix.get(row, col)));
                ++col;
            }
            ++row;
        }
        return result;
    }

    @Override
    public int compareTo(Matrix otherMatrix) {
        assert (otherMatrix.getRows() == this.getRows() && otherMatrix.getColumns() == this.getColumns());
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getColumns()) {
                int comparison = this.get(row, col).compareTo(otherMatrix.get(row, col));
                if (comparison != 0) {
                    return comparison;
                }
                ++col;
            }
            ++row;
        }
        return 0;
    }
}

