/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.energy.RatioGameValueIterationDouble;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.energy.RatioGameValueIterationInt;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy.PolicyIterationDouble;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy.PolicyIterationInt;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.zwick.SolverZPDouble;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.zwick.SolverZPInt;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public abstract class Benchmark {
    protected boolean runPI;
    protected boolean runEG;
    protected boolean runZP;

    public abstract String getName();

    public void setEnabled(boolean runPI, boolean runEG, boolean runZP) {
        this.runPI = runPI;
        this.runEG = runEG;
        this.runZP = runZP;
    }

    public void run(Integer numberOfIterations) {
        this.run(numberOfIterations, this.runPI, this.runEG, this.runZP);
    }

    public abstract void run(Integer var1, boolean var2, boolean var3, boolean var4);

    protected long runPI(RGIntImplJGraphT game) {
        long start = System.nanoTime();
        PolicyIterationInt.solve(game);
        long end = System.nanoTime();
        return end - start;
    }

    protected long runEG(RGIntImplJGraphT game) {
        long start = System.nanoTime();
        RatioGameValueIterationInt.solve(game);
        long end = System.nanoTime();
        return end - start;
    }

    protected long runZP(RGIntImplJGraphT game) {
        long start = System.nanoTime();
        SolverZPInt.getValues(game);
        long end = System.nanoTime();
        return end - start;
    }

    protected long runPI(RGDoubleImplJGraphT game) {
        return this.runPI(game, 1.0E-4);
    }

    protected long runPI(RGDoubleImplJGraphT game, Double epsilon) {
        long start = System.nanoTime();
        PolicyIterationDouble.solve(game, epsilon);
        long end = System.nanoTime();
        return end - start;
    }

    protected long runEG(RGDoubleImplJGraphT game) {
        return this.runEG(game, 1.0E-4);
    }

    protected long runEG(RGDoubleImplJGraphT game, Double epsilon) {
        long start = System.nanoTime();
        RatioGameValueIterationDouble.solve(game, epsilon);
        long end = System.nanoTime();
        return end - start;
    }

    protected long runZP(RGDoubleImplJGraphT game) {
        return this.runZP(game, 1.0E-4);
    }

    protected long runZP(RGDoubleImplJGraphT game, Double epsilon) {
        long start = System.nanoTime();
        SolverZPDouble.getValues(game, epsilon);
        long end = System.nanoTime();
        return end - start;
    }

    protected PrintWriter getFile(String fileName) {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd-hh.mm.ss").format(new Date());
        try {
            return new PrintWriter("results/" + fileName + "_" + timeStamp + ".csv");
        }
        catch (IOException ex) {
            Logger.getLogger(Benchmark.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

