/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.machine.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import machine.FullMeshPath;
import machine.Path;
import machine.PathTargetReference;
import machine.SymbolicPosition;
import machine.impl.MachineQueries;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;

public class DeleteAction
extends AbstractExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> selections) {
        return selections != null && selections.size() == 1;
    }

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        for (EObject eObject : selections) {
            if (eObject instanceof SymbolicPosition) {
                DeleteAction.delete((SymbolicPosition)eObject);
                continue;
            }
            if (!(eObject instanceof Path)) continue;
            DeleteAction.delete((Path)eObject);
        }
    }

    private static void delete(SymbolicPosition symPos) {
        for (Path edge : MachineQueries.findTargetReference((SymbolicPosition)symPos)) {
            DeleteAction.delete(edge);
        }
        for (Path edge : symPos.getOutgoingPaths()) {
            if (edge instanceof FullMeshPath) {
                DeleteAction.deleteMeshTarget(symPos, edge);
                continue;
            }
            DeleteAction.delete(edge);
        }
        EcoreUtil.delete((EObject)symPos);
    }

    private static void delete(Path edge) {
        for (PathTargetReference pathTargetRef : edge.getTargets()) {
            EcoreUtil.delete((EObject)pathTargetRef);
        }
        EcoreUtil.delete((EObject)edge);
    }

    private static void deleteMeshTarget(SymbolicPosition symbPos, Path edge) {
        ArrayList<PathTargetReference> toRemove = new ArrayList<PathTargetReference>();
        for (PathTargetReference pathTargetRef : edge.getTargets()) {
            if (!symbPos.getTargetReferences().contains((Object)pathTargetRef)) continue;
            toRemove.add(pathTargetRef);
        }
        for (PathTargetReference pathTargetRef : toRemove) {
            EcoreUtil.delete((EObject)pathTargetRef);
        }
    }
}

