/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.AEquation;
import org.eclipse.escet.cif.parser.ast.AInitialDecl;
import org.eclipse.escet.cif.parser.ast.AMarkedDecl;
import org.eclipse.escet.cif.parser.ast.annotations.AAnnotation;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.parser.ast.iodecls.AIoDecl;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.declwrap.AlgParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.AlgVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.ConstDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.ContVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.DiscVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumLiteralDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InputVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InvDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InvariantInfo;
import org.eclipse.escet.cif.typechecker.declwrap.LocationDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.LocationParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.TypeDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.CompParamScope;
import org.eclipse.escet.cif.typechecker.scopes.FunctionScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public abstract class ParentScope<T extends PositionObject>
extends SymbolScope<T> {
    protected final Map<String, SymbolScope<?>> children = Maps.map();
    protected final Map<String, DeclWrap<?>> declarations = Maps.map();
    protected final List<InvariantInfo> namelessInvariants = Lists.list();
    protected List<AAnnotation> astAnnotations = Lists.list();
    public Map<String, List<AEquation>> astEquations = Maps.map();
    public Map<AEquation, Equation> mmEquations = Maps.map();
    protected List<AInitialDecl> astInitPreds = Lists.list();
    protected List<AMarkedDecl> astMarkerPreds = Lists.list();
    protected List<AIoDecl> astIoDecls = Lists.list();

    public ParentScope(T obj, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(obj, parent, tchecker);
    }

    protected abstract String getScopeTypeName();

    protected abstract ComplexComponent getComplexComponent();

    protected abstract Group getGroup();

    protected abstract ComponentDef getComponentDef();

    protected abstract Automaton getAutomaton();

    public abstract List<ALocation> getAstLocs();

    public void addEquations(List<AEquation> eqns) {
        for (AEquation eqn : eqns) {
            List prev = this.astEquations.get(eqn.variable.id);
            if (prev == null) {
                prev = Lists.list();
                this.astEquations.put(eqn.variable.id, prev);
            }
            prev.add(eqn);
        }
    }

    public void addDeclaration(DeclWrap<?> decl) {
        this.checkUniqueName(decl);
        this.declarations.put(decl.getName(), decl);
    }

    public void addInvariant(InvariantInfo invariantInfo) {
        if (invariantInfo.astInv.name != null) {
            InvDeclWrap wrapper = new InvDeclWrap(this.tchecker, this, invariantInfo);
            this.checkUniqueName(wrapper);
            this.declarations.put(wrapper.getName(), wrapper);
        } else {
            this.namelessInvariants.add(invariantInfo);
        }
    }

    public void addChildScope(SymbolScope<?> scope) {
        this.checkUniqueName(scope);
        this.children.put(scope.getName(), scope);
    }

    private void checkUniqueName(SymbolTableEntry newEntry) {
        String name = newEntry.getName();
        SymbolScope<?> prevScope = this.children.get(name);
        if (prevScope != null) {
            this.tchecker.addProblem(ErrMsg.DUPLICATE_NAME, newEntry.getPosition(), name, this.getAbsText());
            this.tchecker.addProblem(ErrMsg.DUPLICATE_NAME, prevScope.getPosition(), name, this.getAbsText());
            throw new SemanticException();
        }
        DeclWrap<?> prevDecl = this.declarations.get(name);
        if (prevDecl != null) {
            this.tchecker.addProblem(ErrMsg.DUPLICATE_NAME, newEntry.getPosition(), name, this.getAbsText());
            this.tchecker.addProblem(ErrMsg.DUPLICATE_NAME, prevDecl.getPosition(), name, this.getAbsText());
            throw new SemanticException();
        }
    }

    public boolean defines(String name) {
        return this.children.containsKey(name) || this.declarations.containsKey(name);
    }

    @Override
    public final void tcheckForUseImpl() {
        this.checkName();
        this.tcheckScopeForUse();
        this.status = CheckStatus.USE;
    }

    @Override
    public final void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        boolean failed = false;
        for (DeclWrap<?> declWrap : this.declarations.values()) {
            try {
                declWrap.tcheckFull();
            }
            catch (SemanticException ex) {
                failed = true;
            }
        }
        for (InvariantInfo invariantInfo : this.namelessInvariants) {
            try {
                InvDeclWrap.tcheckFull(this.tchecker, this, invariantInfo);
            }
            catch (SemanticException ex) {
                failed = true;
            }
        }
        for (SymbolScope symbolScope : this.children.values()) {
            try {
                symbolScope.tcheckFull();
            }
            catch (SemanticException ex) {
                failed = true;
            }
        }
        this.tcheckInitMarked();
        if (failed) {
            this.mmEquations = null;
        } else {
            for (List list : this.astEquations.values()) {
                for (AEquation astEqn : list) {
                    Equation eqn = this.mmEquations.get(astEqn);
                    if (eqn != null) {
                        this.getComplexComponent().getEquations().add((Object)eqn);
                        continue;
                    }
                    this.tchecker.addProblem(ErrMsg.EQN_VAR_NOT_IN_SCOPE, astEqn.position, astEqn.variable.id, this.getAbsText());
                }
            }
        }
        if (!this.astIoDecls.isEmpty()) {
            this.tchecker.ioDeclChecker.check(this.astIoDecls, this, this.getComplexComponent());
        }
        this.tcheckScopeFull();
        this.status = CheckStatus.FULL;
    }

    protected void tcheckScopeForUse() {
    }

    protected void tcheckScopeFull() {
    }

    private void tcheckInitMarked() {
        CifType nt;
        CifType t;
        Expression pred2;
        if (this.astInitPreds.isEmpty() && this.astMarkerPreds.isEmpty()) {
            return;
        }
        ComplexComponent ccomp = this.getComplexComponent();
        for (AInitialDecl aInitialDecl : this.astInitPreds) {
            for (AExpression pred : aInitialDecl.preds) {
                pred2 = CifExprsTypeChecker.transExpression(pred, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, this, null, this.tchecker);
                ccomp.getInitials().add((Object)pred2);
                t = pred2.getType();
                nt = CifTypeUtils.normalizeType((CifType)t);
                if (nt instanceof BoolType) continue;
                this.tchecker.addProblem(ErrMsg.INIT_NON_BOOL, pred.position, CifTextUtils.typeToStr((CifType)t));
            }
        }
        for (AMarkedDecl aMarkedDecl : this.astMarkerPreds) {
            for (AExpression pred : aMarkedDecl.preds) {
                pred2 = CifExprsTypeChecker.transExpression(pred, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, this, null, this.tchecker);
                ccomp.getMarkeds().add((Object)pred2);
                t = pred2.getType();
                nt = CifTypeUtils.normalizeType((CifType)t);
                if (nt instanceof BoolType) continue;
                this.tchecker.addProblem(ErrMsg.MARKED_NON_BOOL, pred.position, CifTextUtils.typeToStr((CifType)t));
            }
        }
    }

    public Box toBox() {
        if (this.children.isEmpty() && this.declarations.isEmpty()) {
            return new TextBox(Strings.fmt((String)"[ %s scope \"%s\" for: %s ]", (Object[])new Object[]{this.getScopeTypeName(), this.getName(), this.obj}));
        }
        int rowCount = this.children.size() + this.declarations.size() + 1;
        GridBox grid = new GridBox(rowCount, 4);
        int rowNr = 0;
        for (SymbolScope<?> symbolScope : this.children.values()) {
            grid.set(rowNr, 0, (Box)new TextBox(", "));
            grid.set(rowNr, 1, (Box)new TextBox(symbolScope.getName()));
            grid.set(rowNr, 2, (Box)new TextBox(" : "));
            grid.set(rowNr, 3, symbolScope.toBox());
            ++rowNr;
        }
        for (DeclWrap declWrap : this.declarations.values()) {
            grid.set(rowNr, 0, (Box)new TextBox(", "));
            grid.set(rowNr, 1, (Box)new TextBox(declWrap.getName()));
            grid.set(rowNr, 2, (Box)new TextBox(" : "));
            grid.set(rowNr, 3, (Box)new TextBox(declWrap.toString()));
            ++rowNr;
        }
        grid.set(rowCount - 1, 0, (Box)new TextBox("]"));
        return new VBox(new Object[]{Strings.fmt((String)"[ %s scope \"%s\" for: %s", (Object[])new Object[]{this.getScopeTypeName(), this.getName(), this.obj}), grid});
    }

    @Override
    protected SymbolTableEntry resolve1(TextPosition position, String id, String done, CifTypeChecker tchecker, SymbolScope<?> origScope) {
        String postfixTxt;
        String scopeTxt;
        SymbolTableEntry child = this.children.get(id);
        if (child != null) {
            if (child instanceof CompParamScope) {
                ((CompParamScope)child).used = true;
            }
            if (child instanceof FunctionScope) {
                ((FunctionScope)child).used = true;
            }
            return child;
        }
        DeclWrap<?> decl = this.declarations.get(id);
        if (decl != null) {
            decl.used = true;
            return decl;
        }
        if (done.isEmpty() && !this.isRootScope()) {
            SymbolTableEntry entry = this.parent.resolve1(position, id, done, tchecker, origScope);
            return entry;
        }
        boolean isVia = !done.isEmpty();
        Assert.ifAndOnlyIf((boolean)isVia, (origScope == null ? 1 : 0) != 0);
        if (isVia) {
            scopeTxt = this.getAbsText();
        } else {
            SymbolScope<?> namedScope = origScope;
            while (!(namedScope instanceof ParentScope)) {
                namedScope = namedScope.parent;
            }
            scopeTxt = ((ParentScope)namedScope).getAbsText();
        }
        if (isVia) {
            postfixTxt = "";
        } else {
            Assert.check((boolean)this.isRootScope());
            postfixTxt = this == origScope ? "" : " or at a higher level";
        }
        tchecker.addProblem(ErrMsg.RESOLVE_NOT_FOUND, position, id, scopeTxt, postfixTxt);
        throw new SemanticException();
    }

    public SymbolTableEntry getEntry(String name) {
        SymbolTableEntry entry = this.children.get(name);
        if (entry == null) {
            entry = this.declarations.get(name);
        }
        Assert.notNull((Object)entry);
        return entry;
    }

    @Override
    public void detectCompDefInstCycles(List<ParentScope<?>> cycle) {
        ParentScope<?> top;
        boolean isCompDef;
        boolean bl = isCompDef = this instanceof AutDefScope || this instanceof GroupDefScope;
        if (isCompDef) {
            if (!cycle.contains(this)) {
                cycle.add(this);
            } else {
                int idx = cycle.indexOf(this);
                Assert.check((idx >= 0 ? 1 : 0) != 0);
                int i = idx;
                while (i < cycle.size()) {
                    ParentScope<?> startEntry = cycle.get(i);
                    StringBuilder txt = new StringBuilder();
                    int j = i;
                    while (j < cycle.size()) {
                        if (txt.length() > 0) {
                            txt.append(" -> ");
                        }
                        txt.append(CifTextUtils.getAbsName(cycle.get(j).getObject()));
                        ++j;
                    }
                    j = idx;
                    while (j <= i) {
                        if (txt.length() > 0) {
                            txt.append(" -> ");
                        }
                        txt.append(CifTextUtils.getAbsName(cycle.get(j).getObject()));
                        ++j;
                    }
                    this.tchecker.addProblem(ErrMsg.COMP_DEF_INST_CYCLE, startEntry.getPosition(), CifTextUtils.getAbsName(startEntry.getObject()), txt.toString());
                    ++i;
                }
                throw new SemanticException();
            }
        }
        for (SymbolScope<?> child : this.children.values()) {
            child.detectCompDefInstCycles(cycle);
        }
        if (isCompDef && (top = cycle.remove(cycle.size() - 1)) != this) {
            throw new IllegalStateException("top of cycle != this");
        }
    }

    public void findUnusedDecls() {
        for (SymbolScope<?> symbolScope : this.children.values()) {
            if (symbolScope instanceof CompParamScope) {
                CompParamScope paramScope = (CompParamScope)symbolScope;
                if (!paramScope.used) {
                    this.tchecker.addProblem(ErrMsg.UNUSED_DECL, paramScope.getPosition(), "Component parameter", paramScope.getAbsName());
                }
            }
            if (!(symbolScope instanceof ParentScope)) continue;
            ((ParentScope)symbolScope).findUnusedDecls();
        }
        for (DeclWrap declWrap : this.declarations.values()) {
            String description;
            if (declWrap.used || declWrap instanceof AlgVariableDeclWrap || declWrap instanceof ConstDeclWrap || declWrap instanceof ContVariableDeclWrap) continue;
            if (declWrap instanceof DiscVariableDeclWrap) {
                description = "Discrete variable";
            } else {
                if (declWrap instanceof EnumDeclWrap || declWrap instanceof EnumLiteralDeclWrap) continue;
                if (declWrap instanceof EventDeclWrap) {
                    description = "Event";
                } else if (declWrap instanceof AlgParamDeclWrap) {
                    description = "Algebraic parameter";
                } else if (declWrap instanceof EventParamDeclWrap) {
                    description = "Event parameter";
                } else if (declWrap instanceof LocationParamDeclWrap) {
                    description = "Location parameter";
                } else if (declWrap instanceof FuncParamDeclWrap) {
                    description = "Function parameter";
                } else if (declWrap instanceof FuncVariableDeclWrap) {
                    description = "Variable";
                } else {
                    if (declWrap instanceof InputVariableDeclWrap || declWrap instanceof LocationDeclWrap || declWrap instanceof TypeDeclWrap || declWrap instanceof InvDeclWrap) continue;
                    throw new RuntimeException("Unknown decl: " + String.valueOf(declWrap));
                }
            }
            this.tchecker.addProblem(ErrMsg.UNUSED_DECL, declWrap.getPosition(), description, declWrap.getAbsName());
        }
    }
}

