/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler.product;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.product.productdata.EntryEvent;
import org.eclipse.lsat.product.productdata.ExitEvent;
import org.eclipse.lsat.product.productdata.LifeCycleEvent;
import org.eclipse.lsat.product.productdata.LocationInformation;
import org.eclipse.lsat.product.productdata.ProductInstance;
import org.eclipse.lsat.product.productdata.ProductProperty;
import org.eclipse.lsat.product.productdata.TransferEvent;
import org.eclipse.lsat.product.productdata.TransferInformation;
import org.eclipse.lsat.scheduler.product.ProductChange;
import org.eclipse.lsat.scheduler.product.ProductUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import product.TransferType;

public class ProductTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductTransformer.class);

    private ProductTransformer() {
    }

    public static List<ProductInstance> getProductTracesFromSchedule(Schedule<Task> schedule, boolean debug) {
        List<ProductChange> productChanges = ProductUtil.createProductChanges(schedule);
        ArrayList<ProductInstance> allProducts = new ArrayList<ProductInstance>();
        LinkedHashMap<ProductInstance, ProductChange> activeProducts = new LinkedHashMap<ProductInstance, ProductChange>();
        try {
            ProductTransformer.processProductChanges(productChanges, allProducts, activeProducts, debug);
        }
        catch (Exception e) {
            ProductTransformer.logProductState(activeProducts, allProducts);
            ProductTransformer.logErrorState(activeProducts, allProducts);
            throw e;
        }
        ProductTransformer.logProductState(activeProducts, allProducts);
        return allProducts;
    }

    private static void processProductChanges(List<ProductChange> productChanges, List<ProductInstance> allProducts, Map<ProductInstance, ProductChange> activeProducts, boolean debug) {
        while (!productChanges.isEmpty()) {
            ProductChange productChange = productChanges.removeFirst();
            ProductTransformer.logProductChange(productChange, debug);
            ProductTransformer.processProductChange(productChange, productChanges, allProducts, activeProducts, debug);
            ProductTransformer.logProductStateIfNeeded(productChange, activeProducts, allProducts, debug);
        }
    }

    private static void processProductChange(ProductChange productChange, List<ProductChange> productChanges, List<ProductInstance> allProducts, Map<ProductInstance, ProductChange> activeProducts, boolean debug) {
        if (productChange.isEntry()) {
            ProductTransformer.handleEntryEvent(productChange, allProducts, activeProducts);
        } else if (productChange.isTransfer()) {
            ProductTransformer.handleTransferEvent(productChange, productChanges, activeProducts, debug);
        } else if (productChange.isExit()) {
            ProductTransformer.handleExitEvent(productChange, activeProducts);
        } else {
            ProductTransformer.handlePropertyChange(productChange, activeProducts);
        }
    }

    private static void handleEntryEvent(ProductChange productChange, List<ProductInstance> allProducts, Map<ProductInstance, ProductChange> activeProducts) {
        ProductInstance productInstance = ProductTransformer.startLifeCycle(Integer.toString(allProducts.size()), productChange);
        allProducts.add(productInstance);
        activeProducts.put(productInstance, productChange);
    }

    private static void handleTransferEvent(ProductChange productChange, List<ProductChange> productChanges, Map<ProductInstance, ProductChange> activeProducts, boolean debug) {
        Optional<ProductChange> matchingContextOpt = ProductTransformer.findMatchingProductChange(productChange, productChanges);
        if (matchingContextOpt.isEmpty()) {
            ProductTransformer.throwMatchingContextNotFound(productChange, activeProducts);
        }
        ProductChange matchingContext = matchingContextOpt.get();
        productChanges.remove(matchingContext);
        if (debug) {
            LOGGER.info("Match: " + String.valueOf(matchingContext));
        }
        ProductTransformer.transferLifeCycle(activeProducts, productChange, matchingContext);
    }

    private static void handleExitEvent(ProductChange productChange, Map<ProductInstance, ProductChange> activeProducts) {
        ProductTransformer.endLifeCycle(activeProducts, productChange);
    }

    private static void handlePropertyChange(ProductChange productChange, Map<ProductInstance, ProductChange> activeProducts) {
        ProductTransformer.propertyChange(activeProducts, productChange);
    }

    private static Optional<ProductChange> findMatchingProductChange(ProductChange productChange, List<ProductChange> productChanges) {
        return productChanges.stream().filter(productChange::isMatch).findFirst();
    }

    private static void throwMatchingContextNotFound(ProductChange productChange, Map<ProductInstance, ProductChange> activeProducts) {
        String action = productChange.getTaskData().getId();
        String activity = productChange.getProductOwner().getAction().getGraph().getName();
        String errorMessage = "Action: '%s.%s' - Cannot find a match for %s\n".formatted(activity, action, productChange);
        throw new IllegalArgumentException(errorMessage);
    }

    private static void logProductChange(ProductChange productChange, boolean debug) {
        if (debug && productChange.getTransferType() != TransferType.UNKNOWN) {
            LOGGER.info("ProductChange: " + String.valueOf(productChange));
        }
    }

    private static void logProductStateIfNeeded(ProductChange productChange, Map<ProductInstance, ProductChange> activeProducts, List<ProductInstance> allProducts, boolean debug) {
        if (debug && productChange.getTransferType() != TransferType.UNKNOWN) {
            ProductTransformer.logProductState(activeProducts, allProducts);
        }
    }

    private static void logProductState(Map<ProductInstance, ProductChange> activeProducts, List<ProductInstance> allProducts) {
        ProductUtil.logProductLocations(activeProducts);
        ProductUtil.logProductFlow(allProducts);
    }

    private static void logErrorState(LinkedHashMap<ProductInstance, ProductChange> activeProducts, List<ProductInstance> allProducts) {
        LOGGER.error("Error occurred during product transformation. Current state:");
        ProductTransformer.logProductState(activeProducts, allProducts);
    }

    private static ProductInstance startLifeCycle(String productId, ProductChange prodChange) {
        LocationInformation locationInformation = prodChange.createLocationInformation();
        EntryEvent createEvent = new EntryEvent(locationInformation);
        List<ProductProperty> propertyList = prodChange.getChangedProperties();
        prodChange.initProduct(productId);
        return new ProductInstance(productId, (LifeCycleEvent)createEvent, propertyList);
    }

    private static void transferLifeCycle(Map<ProductInstance, ProductChange> activeProducts, ProductChange prodChange, ProductChange matchingProductChange) {
        List<ProductChange> all = List.of(prodChange, matchingProductChange);
        List<ProductChange> inProducts = all.stream().filter(pd -> pd.getTransferType() == TransferType.IN).toList();
        List<ProductChange> outProducts = all.stream().filter(pd -> pd.getTransferType() == TransferType.OUT).toList();
        ProductTransformer.validateTransferActions(inProducts, outProducts);
        for (ProductChange inProductChange : inProducts) {
            List<ProductProperty> inPropertyList = inProductChange.getChangedProperties();
            LocationInformation inLocation = inProductChange.createLocationInformation();
            for (ProductChange outProductChange : outProducts) {
                List<ProductProperty> outPropertyList = outProductChange.getChangedProperties();
                LocationInformation outLocation = outProductChange.createLocationInformation();
                ProductInstance productInstance = ProductUtil.getProductInstanceThatHasNotPassedSlot(activeProducts, outProductChange.getProductOwner(), outProductChange.getSlot());
                if (productInstance == null) {
                    throw new IllegalStateException("No product instance found for transfer");
                }
                TransferEvent transferEvent = new TransferEvent(new TransferInformation(inLocation, outLocation));
                ProductChange precedingProductChange = activeProducts.get(productInstance);
                outProductChange.setStatus(productInstance.getProductID(), precedingProductChange);
                inProductChange.setStatus(productInstance.getProductID(), outProductChange);
                activeProducts.put(productInstance, inProductChange);
                productInstance.addProductLocationToLifeCycle((LifeCycleEvent)transferEvent);
                productInstance.addPropertiesToList(outPropertyList);
                productInstance.addPropertiesToList(inPropertyList);
            }
        }
    }

    private static void validateTransferActions(List<ProductChange> inProducts, List<ProductChange> outProducts) {
        if (inProducts.size() != 1) {
            throw new IllegalStateException("Expected exactly one IN action, found %d".formatted(inProducts.size()));
        }
        if (outProducts.size() != 1) {
            throw new IllegalStateException("Expected exactly one OUT action, found %d".formatted(outProducts.size()));
        }
    }

    private static void endLifeCycle(Map<ProductInstance, ProductChange> activeProducts, ProductChange prodChange) {
        ProductInstance productInstance = ProductUtil.getProductInstanceForSlot(activeProducts, prodChange.getProductOwner(), prodChange.getSlot());
        if (productInstance == null) {
            throw new IllegalStateException("No product instance found to unload");
        }
        LocationInformation locationInformation = prodChange.createLocationInformation();
        ExitEvent unloadEvent = new ExitEvent(locationInformation);
        prodChange.setStatus(productInstance.getProductID(), activeProducts.get(productInstance));
        productInstance.addProductLocationToLifeCycle((LifeCycleEvent)unloadEvent);
        activeProducts.remove(productInstance);
    }

    private static void propertyChange(Map<ProductInstance, ProductChange> activeProducts, ProductChange prodChange) {
        if (activeProducts.isEmpty()) {
            return;
        }
        List<ProductProperty> propertyList = prodChange.getChangedProperties();
        ProductInstance productInstance = ProductUtil.getProductInstanceForSlot(activeProducts, prodChange.getProductOwner(), prodChange.getSlot());
        if (productInstance == null) {
            if (!propertyList.isEmpty()) {
                LOGGER.warn("No product instance found for property change: " + String.valueOf(prodChange) + System.lineSeparator() + "Candidates:" + System.lineSeparator() + ProductUtil.getProductLocationsString(activeProducts));
            }
            return;
        }
        prodChange.setStatus(productInstance.getProductID(), activeProducts.get(productInstance));
        activeProducts.put(productInstance, prodChange);
        productInstance.addPropertiesToList(propertyList);
    }
}

